/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.io.netty.handler.codec.http.EmptyHttpHeaders;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.apache.hive.druid.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import org.apache.hive.druid.io.netty.handler.codec.http.cookie.Cookie;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;

public class NettyResponse
implements Response {
    private final List<HttpResponseBodyPart> bodyParts;
    private final HttpHeaders headers;
    private final HttpResponseStatus status;
    private List<Cookie> cookies;

    public NettyResponse(HttpResponseStatus status, HttpHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        this.bodyParts = bodyParts;
        this.headers = headers;
        this.status = status;
    }

    private List<Cookie> buildCookies() {
        List setCookieHeaders = this.headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE2);
        if (!MiscUtils.isNonEmpty(setCookieHeaders)) {
            setCookieHeaders = this.headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE);
        }
        if (MiscUtils.isNonEmpty(setCookieHeaders)) {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>(1);
            for (String value : setCookieHeaders) {
                Cookie c = ClientCookieDecoder.STRICT.decode(value);
                if (c == null) continue;
                cookies.add(c);
            }
            return Collections.unmodifiableList(cookies);
        }
        return Collections.emptyList();
    }

    @Override
    public final int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public final String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public final Uri getUri() {
        return this.status.getUri();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.status.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.status.getLocalAddress();
    }

    @Override
    public final String getContentType() {
        return this.headers != null ? this.getHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE) : null;
    }

    @Override
    public final String getHeader(CharSequence name) {
        return this.headers != null ? this.getHeaders().get(name) : null;
    }

    @Override
    public final List<String> getHeaders(CharSequence name) {
        return this.headers != null ? this.getHeaders().getAll(name) : Collections.emptyList();
    }

    @Override
    public final HttpHeaders getHeaders() {
        return this.headers != null ? this.headers : EmptyHttpHeaders.INSTANCE;
    }

    @Override
    public final boolean isRedirected() {
        switch (this.status.getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        if (this.cookies == null) {
            this.cookies = this.buildCookies();
        }
        return this.cookies;
    }

    @Override
    public boolean hasResponseStatus() {
        return this.status != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public boolean hasResponseBody() {
        return MiscUtils.isNonEmpty(this.bodyParts);
    }

    @Override
    public byte[] getResponseBodyAsBytes() {
        return this.getResponseBodyAsByteBuffer().array();
    }

    @Override
    public ByteBuffer getResponseBodyAsByteBuffer() {
        int length = 0;
        for (HttpResponseBodyPart part : this.bodyParts) {
            length += part.length();
        }
        ByteBuffer target = ByteBuffer.wrap(new byte[length]);
        for (HttpResponseBodyPart part : this.bodyParts) {
            target.put(part.getBodyPartBytes());
        }
        target.flip();
        return target;
    }

    @Override
    public String getResponseBody() {
        return this.getResponseBody(MiscUtils.withDefault(HttpUtils.extractContentTypeCharsetAttribute(this.getContentType()), StandardCharsets.UTF_8));
    }

    @Override
    public String getResponseBody(Charset charset) {
        return new String(this.getResponseBodyAsBytes(), charset);
    }

    @Override
    public InputStream getResponseBodyAsStream() {
        return new ByteArrayInputStream(this.getResponseBodyAsBytes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" {\n").append("\tstatusCode=").append(this.getStatusCode()).append("\n").append("\theaders=\n");
        for (Map.Entry header : this.getHeaders()) {
            sb.append("\t\t").append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\n");
        }
        return sb.append("\tbody=\n").append(this.getResponseBody()).append("\n").append("}").toString();
    }
}

