/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpecFactory;

public class NumberedShardSpecFactory
implements ShardSpecFactory {
    private static final NumberedShardSpecFactory INSTANCE = new NumberedShardSpecFactory();

    public static NumberedShardSpecFactory instance() {
        return INSTANCE;
    }

    private NumberedShardSpecFactory() {
    }

    @Override
    public ShardSpec create(ObjectMapper objectMapper, @Nullable ShardSpec specOfPreviousMaxPartitionId) {
        if (specOfPreviousMaxPartitionId == null) {
            return new NumberedShardSpec(0, 0);
        }
        NumberedShardSpec prevSpec = (NumberedShardSpec)specOfPreviousMaxPartitionId;
        return new NumberedShardSpec(prevSpec.getPartitionNum() + 1, prevSpec.getPartitions());
    }

    @Override
    public ShardSpec create(ObjectMapper objectMapper, int partitionId) {
        return new NumberedShardSpec(partitionId, 0);
    }

    @Override
    public Class<? extends ShardSpec> getShardSpecClass() {
        return NumberedShardSpec.class;
    }
}

