/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpecLookup;

public class NumberedShardSpec
implements ShardSpec {
    @JsonIgnore
    private final int partitionNum;
    @JsonIgnore
    private final int partitions;

    @JsonCreator
    public NumberedShardSpec(@JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="partitions") int partitions) {
        Preconditions.checkArgument(partitionNum >= 0, "partitionNum >= 0");
        Preconditions.checkArgument(partitions >= 0, "partitions >= 0");
        this.partitionNum = partitionNum;
        this.partitions = partitions;
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    @Override
    public ShardSpecLookup getLookup(List<ShardSpec> shardSpecs) {
        return (timestamp, row) -> (ShardSpec)shardSpecs.get(0);
    }

    @Override
    public List<String> getDomainDimensions() {
        return ImmutableList.of();
    }

    @Override
    public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
        return true;
    }

    @Override
    public boolean isCompatible(Class<? extends ShardSpec> other) {
        return other == NumberedShardSpec.class || other == NumberedOverwriteShardSpec.class;
    }

    @JsonProperty(value="partitions")
    public int getPartitions() {
        return this.partitions;
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return NumberedPartitionChunk.make(this.partitionNum, this.partitions, obj);
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return true;
    }

    public String toString() {
        return "NumberedShardSpec{partitionNum=" + this.partitionNum + ", partitions=" + this.partitions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberedShardSpec)) {
            return false;
        }
        NumberedShardSpec that = (NumberedShardSpec)o;
        if (this.partitionNum != that.partitionNum) {
            return false;
        }
        return this.partitions == that.partitions;
    }

    public int hashCode() {
        return Objects.hash(this.partitionNum, this.partitions);
    }
}

