/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.timeline.partition.LinearPartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpecLookup;

public final class LinearShardSpec
implements ShardSpec {
    private final int partitionNum;

    @JsonCreator
    public LinearShardSpec(@JsonProperty(value="partitionNum") Integer partitionNum) {
        this.partitionNum = Preconditions.checkNotNull(partitionNum, "Must set partitionNum on LinearShardSpec");
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    @Override
    public ShardSpecLookup getLookup(List<ShardSpec> shardSpecs) {
        return (timestamp, row) -> (ShardSpec)shardSpecs.get(0);
    }

    @Override
    public List<String> getDomainDimensions() {
        return ImmutableList.of();
    }

    @Override
    public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
        return true;
    }

    @Override
    public boolean isCompatible(Class<? extends ShardSpec> other) {
        return other == LinearShardSpec.class;
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new LinearPartitionChunk<T>(this.partitionNum, obj);
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinearShardSpec)) {
            return false;
        }
        LinearShardSpec that = (LinearShardSpec)o;
        return this.partitionNum == that.partitionNum;
    }

    public int hashCode() {
        return this.partitionNum;
    }

    public String toString() {
        return "LinearShardSpec{partitionNum=" + this.partitionNum + '}';
    }
}

