/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.storage.hdfs;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HadoopFsWrapper;
import org.apache.hadoop.fs.Path;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.common.utils.UUIDUtils;
import org.apache.hive.druid.org.apache.druid.guice.Hdfs;
import org.apache.hive.druid.org.apache.druid.java.util.common.IOE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.segment.SegmentUtils;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.utils.CompressionUtils;
import org.joda.time.format.ISODateTimeFormat;

public class HdfsDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(HdfsDataSegmentPusher.class);
    private final Configuration hadoopConfig;
    private final ObjectMapper jsonMapper;
    private final Supplier<String> fullyQualifiedStorageDirectory;

    @Inject
    public HdfsDataSegmentPusher(HdfsDataSegmentPusherConfig config, @Hdfs Configuration hadoopConfig, ObjectMapper jsonMapper) {
        this.hadoopConfig = hadoopConfig;
        this.jsonMapper = jsonMapper;
        Path storageDir = new Path(config.getStorageDirectory());
        this.fullyQualifiedStorageDirectory = Suppliers.memoize(() -> {
            try {
                return FileSystem.newInstance((URI)storageDir.toUri(), (Configuration)hadoopConfig).makeQualified(storageDir).toUri().toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    @Override
    public String getPathForHadoop() {
        return this.fullyQualifiedStorageDirectory.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSegment push(File inDir, DataSegment segment, boolean useUniquePath) throws IOException {
        DataSegment dataSegment;
        String storageDir = this.getStorageDir(segment, false);
        log.debug("Copying segment[%s] to HDFS at location[%s/%s]", segment.getId(), this.fullyQualifiedStorageDirectory.get(), storageDir);
        Path tmpIndexFile = new Path(StringUtils.format("%s/%s/%s/%s_index.zip", this.fullyQualifiedStorageDirectory.get(), segment.getDataSource(), UUIDUtils.generateUuid(new String[0]), segment.getShardSpec().getPartitionNum()));
        FileSystem fs = tmpIndexFile.getFileSystem(this.hadoopConfig);
        fs.mkdirs(tmpIndexFile.getParent());
        log.debug("Compressing files from[%s] to [%s]", inDir, tmpIndexFile);
        try {
            long size;
            try (FSDataOutputStream out = fs.create(tmpIndexFile);){
                size = CompressionUtils.zip(inDir, (OutputStream)out);
            }
            String uniquePrefix = useUniquePath ? DataSegmentPusher.generateUniquePath() + "_" : "";
            Path outIndexFile = new Path(StringUtils.format("%s/%s/%d_%sindex.zip", this.fullyQualifiedStorageDirectory.get(), storageDir, segment.getShardSpec().getPartitionNum(), uniquePrefix));
            dataSegment = segment.withLoadSpec(this.makeLoadSpec(outIndexFile.toUri())).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir(inDir));
            fs.mkdirs(outIndexFile.getParent());
            this.copyFilesWithChecks(fs, tmpIndexFile, outIndexFile);
        }
        catch (Throwable throwable) {
            try {
                if (fs.exists(tmpIndexFile.getParent()) && !fs.delete(tmpIndexFile.getParent(), true)) {
                    log.error("Failed to delete temp directory[%s]", tmpIndexFile.getParent());
                }
            }
            catch (IOException ex) {
                log.error(ex, "Failed to delete temp directory[%s]", tmpIndexFile.getParent());
            }
            throw throwable;
        }
        try {
            if (fs.exists(tmpIndexFile.getParent()) && !fs.delete(tmpIndexFile.getParent(), true)) {
                log.error("Failed to delete temp directory[%s]", tmpIndexFile.getParent());
            }
        }
        catch (IOException ex) {
            log.error(ex, "Failed to delete temp directory[%s]", tmpIndexFile.getParent());
        }
        return dataSegment;
    }

    private void copyFilesWithChecks(FileSystem fs, Path from, Path to) throws IOException {
        if (!HadoopFsWrapper.rename(fs, from, to)) {
            if (fs.exists(to)) {
                log.info("Unable to rename temp file [%s] to segment path [%s], it may have already been pushed by a replica task.", from, to);
            } else {
                throw new IOE("Failed to rename temp file [%s] and final segment path [%s] is not present.", from, to);
            }
        }
    }

    @Override
    public Map<String, Object> makeLoadSpec(URI finalIndexZipFilePath) {
        return ImmutableMap.of("type", "hdfs", "path", finalIndexZipFilePath.toString());
    }

    @Override
    public String getStorageDir(DataSegment segment, boolean useUniquePath) {
        Preconditions.checkArgument(!useUniquePath, "useUniquePath must be false for HdfsDataSegmentPusher.getStorageDir()");
        return JOINER.join(segment.getDataSource(), StringUtils.format("%s_%s", segment.getInterval().getStart().toString(ISODateTimeFormat.basicDateTime()), segment.getInterval().getEnd().toString(ISODateTimeFormat.basicDateTime())), segment.getVersion().replace(':', '_'));
    }

    @Override
    public String makeIndexPathName(DataSegment dataSegment, String indexName) {
        return StringUtils.format("./%s/%d_%s", this.getStorageDir(dataSegment, false), dataSegment.getShardSpec().getPartitionNum(), indexName);
    }
}

