/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.router;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.server.router.PriorityTieredBrokerSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.server.router.TieredBrokerSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.server.router.TimeBoundaryTieredBrokerSelectorStrategy;
import org.joda.time.Period;

public class TieredBrokerConfig {
    public static final String DEFAULT_COORDINATOR_SERVICE_NAME = "druid/coordinator";
    public static final String DEFAULT_BROKER_SERVICE_NAME = "druid/broker";
    @JsonProperty
    @NotNull
    private String defaultBrokerServiceName = "druid/broker";
    @JsonProperty
    private LinkedHashMap<String, String> tierToBrokerMap;
    @JsonProperty
    @NotNull
    private String defaultRule = "_default";
    @JsonProperty
    @NotNull
    private Period pollPeriod = new Period((Object)"PT1M");
    @JsonProperty
    @NotNull
    private List<TieredBrokerSelectorStrategy> strategies = Arrays.asList(new TimeBoundaryTieredBrokerSelectorStrategy(), new PriorityTieredBrokerSelectorStrategy(0, 1));

    public LinkedHashMap<String, String> getTierToBrokerMap() {
        return this.tierToBrokerMap == null ? new LinkedHashMap<String, String>(ImmutableMap.of("_default_tier", this.defaultBrokerServiceName)) : this.tierToBrokerMap;
    }

    public String getDefaultBrokerServiceName() {
        return this.defaultBrokerServiceName;
    }

    public String getDefaultRule() {
        return this.defaultRule;
    }

    public Period getPollPeriod() {
        return this.pollPeriod;
    }

    public List<TieredBrokerSelectorStrategy> getStrategies() {
        return ImmutableList.copyOf(this.strategies);
    }
}

