/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.Monitor;

public class MonitorsConfig {
    private static final Logger log = new Logger(MonitorsConfig.class);
    public static final String METRIC_DIMENSION_PREFIX = "druid.metrics.emitter.dimension.";
    public static final String METAMX_PACKAGE = "com.metamx.metrics";
    public static final String IO_DRUID_PACKAGE = "io.druid.java.util.metrics";
    public static final String APACHE_DRUID_PACKAGE_NAME = "org.apache.hive.druid.org.apache.druid.java.util.metrics";
    @JsonProperty(value="monitors")
    @NotNull
    private List<Class<? extends Monitor>> monitors;

    public List<Class<? extends Monitor>> getMonitors() {
        return this.monitors;
    }

    public MonitorsConfig(@JsonProperty(value="monitors") List<String> monitorNames) {
        this.monitors = MonitorsConfig.getMonitorsFromNames(monitorNames);
    }

    public String toString() {
        return "MonitorsConfig{monitors=" + this.monitors + '}';
    }

    public static Map<String, String[]> mapOfDatasourceAndTaskID(String datasource, String taskId) {
        ImmutableMap.Builder<String, String[]> builder = ImmutableMap.builder();
        if (datasource != null) {
            builder.put("dataSource", new String[]{datasource});
        }
        if (taskId != null) {
            builder.put("id", new String[]{taskId});
        }
        return builder.build();
    }

    public static Map<String, String[]> extractDimensions(Properties props, List<String> dimensions) {
        HashMap<String, String[]> dimensionsMap = new HashMap<String, String[]>();
        for (String property : props.stringPropertyNames()) {
            String dimension;
            if (!property.startsWith(METRIC_DIMENSION_PREFIX) || !dimensions.contains(dimension = property.substring(METRIC_DIMENSION_PREFIX.length()))) continue;
            dimensionsMap.put(dimension, new String[]{props.getProperty(property)});
        }
        return dimensionsMap;
    }

    private static List<Class<? extends Monitor>> getMonitorsFromNames(List<String> monitorNames) {
        ArrayList<Class<? extends Monitor>> monitors = new ArrayList<Class<? extends Monitor>>();
        if (monitorNames == null) {
            return monitors;
        }
        try {
            for (String monitorName : monitorNames) {
                String effectiveMonitorName = StringUtils.replace(StringUtils.replace(monitorName, METAMX_PACKAGE, APACHE_DRUID_PACKAGE_NAME), IO_DRUID_PACKAGE, APACHE_DRUID_PACKAGE_NAME);
                if (!effectiveMonitorName.equals(monitorName)) {
                    log.warn("Deprecated Monitor class name[%s] found, please use name[%s] instead.", monitorName, effectiveMonitorName);
                }
                Class<?> monitorClass = Class.forName(effectiveMonitorName);
                monitors.add(monitorClass);
            }
            return monitors;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }
}

