/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.lookup.cache;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.hive.druid.org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.hive.druid.org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.hive.druid.org.apache.druid.discovery.LookupNodeService;
import org.apache.hive.druid.org.apache.druid.server.http.HostAndPortWithScheme;

public class LookupNodeDiscovery {
    private final DruidNodeDiscovery druidNodeDiscovery;

    LookupNodeDiscovery(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider) {
        this.druidNodeDiscovery = druidNodeDiscoveryProvider.getForService("lookupNodeService");
    }

    public Collection<HostAndPortWithScheme> getNodesInTier(final String tier) {
        return Collections2.transform(Collections2.filter(this.druidNodeDiscovery.getAllNodes(), new Predicate<DiscoveryDruidNode>(){

            @Override
            public boolean apply(@Nullable DiscoveryDruidNode node) {
                return tier.equals(((LookupNodeService)node.getServices().get("lookupNodeService")).getLookupTier());
            }
        }), new Function<DiscoveryDruidNode, HostAndPortWithScheme>(){

            @Override
            public HostAndPortWithScheme apply(@Nullable DiscoveryDruidNode input) {
                return HostAndPortWithScheme.fromString(input.getDruidNode().getServiceScheme(), input.getDruidNode().getHostAndPortToUse());
            }
        });
    }

    public Set<String> getAllTiers() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        this.druidNodeDiscovery.getAllNodes().forEach(node -> builder.add(((LookupNodeService)node.getServices().get("lookupNodeService")).getLookupTier()));
        return builder.build();
    }
}

