/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.log;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.server.QueryStats;
import org.apache.hive.druid.org.apache.druid.server.RequestLogLine;
import org.apache.hive.druid.org.apache.druid.server.log.RequestLogEvent;
import org.joda.time.DateTime;

public final class DefaultRequestLogEvent
implements RequestLogEvent {
    private final ImmutableMap<String, String> serviceDimensions;
    private final String feed;
    private final RequestLogLine request;

    DefaultRequestLogEvent(ImmutableMap<String, String> serviceDimensions, String feed, RequestLogLine request) {
        this.serviceDimensions = serviceDimensions;
        this.request = request;
        this.feed = feed;
    }

    @Override
    @JsonValue(value=false)
    public Map<String, Object> toMap() {
        return ImmutableMap.of();
    }

    @Override
    @JsonProperty(value="feed")
    public String getFeed() {
        return this.feed;
    }

    @JsonProperty(value="timestamp")
    public DateTime getCreatedTime() {
        return this.request.getTimestamp();
    }

    @JsonProperty(value="service")
    public String getService() {
        return this.serviceDimensions.get("service");
    }

    @JsonProperty(value="host")
    public String getHost() {
        return this.serviceDimensions.get("host");
    }

    @JsonProperty(value="query")
    public Query getQuery() {
        return this.request.getQuery();
    }

    @JsonProperty(value="sql")
    public String getSql() {
        return this.request.getSql();
    }

    @JsonProperty(value="remoteAddr")
    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    @JsonProperty(value="queryStats")
    public QueryStats getQueryStats() {
        return this.request.getQueryStats();
    }
}

