/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.server.RequestLogLine;
import org.apache.hive.druid.org.apache.druid.server.log.RequestLogger;
import org.apache.hive.druid.org.apache.druid.server.log.RequestLoggerProvider;

@JsonTypeName(value="composing")
public class ComposingRequestLoggerProvider
implements RequestLoggerProvider {
    private static final Logger log = new Logger(ComposingRequestLoggerProvider.class);
    @JsonProperty
    @NotNull
    private final List<RequestLoggerProvider> loggerProviders = new ArrayList<RequestLoggerProvider>();

    public RequestLogger get() {
        ArrayList<RequestLogger> loggers = new ArrayList<RequestLogger>();
        for (RequestLoggerProvider loggerProvider : this.loggerProviders) {
            loggers.add((RequestLogger)loggerProvider.get());
        }
        ComposingRequestLogger logger = new ComposingRequestLogger(loggers);
        log.debug(new Exception("Stack trace"), "Creating %s at", logger);
        return logger;
    }

    public static class ComposingRequestLogger
    implements RequestLogger {
        private final List<RequestLogger> loggers;

        public ComposingRequestLogger(List<RequestLogger> loggers) {
            this.loggers = loggers;
        }

        @Override
        @LifecycleStart
        public void start() throws Exception {
            for (RequestLogger logger : this.loggers) {
                logger.start();
            }
        }

        @Override
        @LifecycleStop
        public void stop() {
            for (RequestLogger logger : this.loggers) {
                logger.stop();
            }
        }

        @Override
        public void logNativeQuery(RequestLogLine requestLogLine) throws IOException {
            this.delegateToAllChildren(requestLogLine, RequestLogger::logNativeQuery);
        }

        @Override
        public void logSqlQuery(RequestLogLine requestLogLine) throws IOException {
            this.delegateToAllChildren(requestLogLine, RequestLogger::logSqlQuery);
        }

        private void delegateToAllChildren(RequestLogLine requestLogLine, RequestLogLineConsumer consumer) throws IOException {
            Exception exception = null;
            for (RequestLogger logger : this.loggers) {
                try {
                    consumer.accept(logger, requestLogLine);
                }
                catch (Exception e) {
                    if (exception == null) {
                        exception = e;
                        continue;
                    }
                    exception.addSuppressed(e);
                }
            }
            if (exception != null) {
                Throwables.propagateIfInstanceOf(exception, IOException.class);
                throw new RuntimeException(exception);
            }
        }

        public String toString() {
            return "ComposingRequestLogger{loggers=" + this.loggers + '}';
        }

        private static interface RequestLogLineConsumer {
            public void accept(RequestLogger var1, RequestLogLine var2) throws IOException;
        }
    }
}

