/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.initialization;

import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;

public class ZkPathsConfig {
    @JsonProperty
    private String base = "druid";
    @JsonProperty
    private String propertiesPath;
    @JsonProperty
    private String announcementsPath;
    @JsonProperty
    @Deprecated
    private String servedSegmentsPath;
    @JsonProperty
    private String liveSegmentsPath;
    @JsonProperty
    private String coordinatorPath;
    @JsonProperty
    private String loadQueuePath;
    @JsonProperty
    private String connectorPath;

    public String getBase() {
        return this.base;
    }

    public String getPropertiesPath() {
        return null == this.propertiesPath ? this.defaultPath("properties") : this.propertiesPath;
    }

    public String getAnnouncementsPath() {
        return null == this.announcementsPath ? this.defaultPath("announcements") : this.announcementsPath;
    }

    @Deprecated
    public String getServedSegmentsPath() {
        return null == this.servedSegmentsPath ? this.defaultPath("servedSegments") : this.servedSegmentsPath;
    }

    public String getLiveSegmentsPath() {
        return null == this.liveSegmentsPath ? this.defaultPath("segments") : this.liveSegmentsPath;
    }

    public String getCoordinatorPath() {
        return null == this.coordinatorPath ? this.defaultPath("coordinator") : this.coordinatorPath;
    }

    public String getOverlordPath() {
        return this.defaultPath("overlord");
    }

    public String getLoadQueuePath() {
        return null == this.loadQueuePath ? this.defaultPath("loadQueue") : this.loadQueuePath;
    }

    public String getConnectorPath() {
        return null == this.connectorPath ? this.defaultPath("connector") : this.connectorPath;
    }

    public String getInternalDiscoveryPath() {
        return this.defaultPath("internal-discovery");
    }

    public String defaultPath(String subPath) {
        return ZKPaths.makePath((String)this.getBase(), (String)subPath);
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof ZkPathsConfig)) {
            return false;
        }
        ZkPathsConfig otherConfig = (ZkPathsConfig)other;
        return this.getBase().equals(otherConfig.getBase()) && this.getAnnouncementsPath().equals(otherConfig.getAnnouncementsPath()) && this.getConnectorPath().equals(otherConfig.getConnectorPath()) && this.getLiveSegmentsPath().equals(otherConfig.getLiveSegmentsPath()) && this.getCoordinatorPath().equals(otherConfig.getCoordinatorPath()) && this.getLoadQueuePath().equals(otherConfig.getLoadQueuePath()) && this.getPropertiesPath().equals(otherConfig.getPropertiesPath()) && this.getServedSegmentsPath().equals(otherConfig.getServedSegmentsPath());
    }

    public int hashCode() {
        int result = this.base != null ? this.base.hashCode() : 0;
        result = 31 * result + (this.propertiesPath != null ? this.propertiesPath.hashCode() : 0);
        result = 31 * result + (this.announcementsPath != null ? this.announcementsPath.hashCode() : 0);
        result = 31 * result + (this.servedSegmentsPath != null ? this.servedSegmentsPath.hashCode() : 0);
        result = 31 * result + (this.liveSegmentsPath != null ? this.liveSegmentsPath.hashCode() : 0);
        result = 31 * result + (this.coordinatorPath != null ? this.coordinatorPath.hashCode() : 0);
        result = 31 * result + (this.loadQueuePath != null ? this.loadQueuePath.hashCode() : 0);
        result = 31 * result + (this.connectorPath != null ? this.connectorPath.hashCode() : 0);
        return result;
    }
}

