/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.initialization;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigurator;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.LifecycleModule;
import org.apache.hive.druid.org.apache.druid.initialization.DruidModule;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.hive.druid.org.apache.druid.server.security.AuthConfig;
import org.apache.hive.druid.org.apache.druid.server.security.Authenticator;
import org.apache.hive.druid.org.apache.druid.server.security.AuthenticatorMapper;

public class AuthenticatorMapperModule
implements DruidModule {
    private static final String AUTHENTICATOR_PROPERTIES_FORMAT_STRING = "druid.auth.authenticator.%s";
    private static Logger log = new Logger(AuthenticatorMapperModule.class);

    public void configure(Binder binder) {
        binder.bind(AuthenticatorMapper.class).toProvider((Provider)new AuthenticatorMapperProvider()).in(LazySingleton.class);
        LifecycleModule.register(binder, AuthenticatorMapper.class);
    }

    @Override
    public List<? extends Module> getJacksonModules() {
        return Collections.EMPTY_LIST;
    }

    private static void validateAuthenticators(List<String> authenticators) {
        if (authenticators == null) {
            return;
        }
        if (authenticators.isEmpty()) {
            throw new IAE("Must have at least one Authenticator configured.", new Object[0]);
        }
        HashSet<String> authenticatorSet = new HashSet<String>();
        for (String authenticator : authenticators) {
            if (authenticatorSet.contains(authenticator)) {
                throw new ISE("Cannot have multiple authenticators with the same name: [%s]", authenticator);
            }
            authenticatorSet.add(authenticator);
        }
    }

    private static class AuthenticatorMapperProvider
    implements Provider<AuthenticatorMapper> {
        private AuthConfig authConfig;
        private Injector injector;
        private Properties props;
        private JsonConfigurator configurator;

        private AuthenticatorMapperProvider() {
        }

        @Inject
        public void inject(Injector injector, Properties props, JsonConfigurator configurator) {
            this.authConfig = (AuthConfig)injector.getInstance(AuthConfig.class);
            this.injector = injector;
            this.props = props;
            this.configurator = configurator;
        }

        public AuthenticatorMapper get() {
            LinkedHashMap<String, Authenticator> authenticatorMap = Maps.newLinkedHashMap();
            List<String> authenticators = this.authConfig.getAuthenticatorChain();
            AuthenticatorMapperModule.validateAuthenticators(authenticators);
            if (authenticators == null) {
                authenticatorMap.put("allowAll", new AllowAllAuthenticator());
                return new AuthenticatorMapper(authenticatorMap);
            }
            for (String authenticatorName : authenticators) {
                String authenticatorPropertyBase = StringUtils.format(AuthenticatorMapperModule.AUTHENTICATOR_PROPERTIES_FORMAT_STRING, authenticatorName);
                JsonConfigProvider<Authenticator> authenticatorProvider = JsonConfigProvider.of(authenticatorPropertyBase, Authenticator.class);
                Properties adjustedProps = new Properties(this.props);
                String nameProperty = StringUtils.format("druid.auth.authenticator.%s.name", authenticatorName);
                if (adjustedProps.containsKey(nameProperty)) {
                    throw new IAE("Name property [%s] is reserved.", nameProperty);
                }
                adjustedProps.put(nameProperty, authenticatorName);
                authenticatorProvider.inject(adjustedProps, this.configurator);
                Object authenticatorSupplier = authenticatorProvider.get();
                if (authenticatorSupplier == null) {
                    throw new ISE("Could not create authenticator with name: %s", authenticatorName);
                }
                Authenticator authenticator = (Authenticator)authenticatorSupplier.get();
                authenticatorMap.put(authenticatorName, authenticator);
            }
            return new AuthenticatorMapper(authenticatorMap);
        }
    }
}

