/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.hive.druid.org.apache.druid.discovery.NodeRole;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Self;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.apache.hive.druid.org.apache.druid.server.http.security.StateResourceFilter;

@Singleton
@Path(value="/status/selfDiscovered")
public class SelfDiscoveryResource {
    private final List<BooleanSupplier> selfDiscoveredRoles;

    @Inject
    public SelfDiscoveryResource(final @Self DruidNode thisDruidNode, @Self Set<NodeRole> thisNodeRoles, final DruidNodeDiscoveryProvider nodeDiscoveryProvider, Lifecycle lifecycle) {
        this.selfDiscoveredRoles = Lists.newArrayListWithExpectedSize(thisNodeRoles.size());
        thisNodeRoles.forEach(thisNodeRole -> {
            Lifecycle.Handler selfDiscoveryListenerRegistrator = new Lifecycle.Handler((NodeRole)((Object)thisNodeRole)){
                final /* synthetic */ NodeRole val$thisNodeRole;
                {
                    this.val$thisNodeRole = nodeRole;
                }

                @Override
                public void start() {
                    SelfDiscoveryResource.this.selfDiscoveredRoles.add(nodeDiscoveryProvider.getForNode(thisDruidNode, this.val$thisNodeRole));
                }

                @Override
                public void stop() {
                }
            };
            lifecycle.addHandler(selfDiscoveryListenerRegistrator, Lifecycle.Stage.SERVER);
        });
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getSelfDiscoveredStatus() {
        return Response.ok(Collections.singletonMap("selfDiscovered", this.isDiscoveredAllRoles())).build();
    }

    @GET
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getSelfDiscovered() {
        if (this.isDiscoveredAllRoles()) {
            return Response.ok().build();
        }
        return Response.status((int)503).build();
    }

    private boolean isDiscoveredAllRoles() {
        return this.selfDiscoveredRoles.stream().allMatch(BooleanSupplier::getAsBoolean);
    }
}

