/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.audit.AuditEntry;
import org.apache.hive.druid.org.apache.druid.audit.AuditInfo;
import org.apache.hive.druid.org.apache.druid.audit.AuditManager;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.org.apache.druid.server.http.security.RulesResourceFilter;
import org.apache.hive.druid.org.apache.druid.server.http.security.StateResourceFilter;
import org.joda.time.Interval;

@Path(value="/druid/coordinator/v1/rules")
public class RulesResource {
    public static final String RULES_ENDPOINT = "/druid/coordinator/v1/rules";
    private final MetadataRuleManager databaseRuleManager;
    private final AuditManager auditManager;

    @Inject
    public RulesResource(MetadataRuleManager databaseRuleManager, AuditManager auditManager) {
        this.databaseRuleManager = databaseRuleManager;
        this.auditManager = auditManager;
    }

    @GET
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getRules() {
        return Response.ok(this.databaseRuleManager.getAllRules()).build();
    }

    @GET
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={RulesResourceFilter.class})
    public Response getDatasourceRules(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        if (full != null) {
            return Response.ok(this.databaseRuleManager.getRulesWithDefault(dataSourceName)).build();
        }
        return Response.ok(this.databaseRuleManager.getRules(dataSourceName)).build();
    }

    @POST
    @Path(value="/{dataSourceName}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={RulesResourceFilter.class})
    public Response setDatasourceRules(@PathParam(value="dataSourceName") String dataSourceName, List<Rule> rules, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        if (this.databaseRuleManager.overrideRule(dataSourceName, rules, new AuditInfo(author, comment, req.getRemoteAddr()))) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @GET
    @Path(value="/{dataSourceName}/history")
    @Produces(value={"application/json"})
    @ResourceFilters(value={RulesResourceFilter.class})
    public Response getDatasourceRuleHistory(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval, @QueryParam(value="count") Integer count) {
        try {
            return Response.ok(this.getRuleHistory(dataSourceName, interval, count)).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ImmutableMap.of("error", e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/history")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getDatasourceRuleHistory(@QueryParam(value="interval") String interval, @QueryParam(value="count") Integer count) {
        try {
            return Response.ok(this.getRuleHistory(null, interval, count)).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ImmutableMap.of("error", e.getMessage())).build();
        }
    }

    private List<AuditEntry> getRuleHistory(String dataSourceName, String interval, Integer count) throws IllegalArgumentException {
        Interval theInterval;
        if (interval == null && count != null) {
            if (dataSourceName != null) {
                return this.auditManager.fetchAuditHistory(dataSourceName, "rules", count);
            }
            return this.auditManager.fetchAuditHistory("rules", count);
        }
        Interval interval2 = theInterval = interval == null ? null : Intervals.of(interval);
        if (dataSourceName != null) {
            return this.auditManager.fetchAuditHistory(dataSourceName, "rules", theInterval);
        }
        return this.auditManager.fetchAuditHistory("rules", theInterval);
    }
}

