/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.emitter;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.ParametrizedUriEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.ParametrizedUriEmitterConfig;
import org.apache.hive.druid.org.apache.druid.server.emitter.HttpEmitterModule;
import org.apache.hive.druid.org.apache.druid.server.emitter.HttpEmitterSSLClientConfig;
import org.apache.hive.druid.org.apache.druid.server.emitter.ParametrizedUriEmitterSSLClientConfig;

public class ParametrizedUriEmitterModule
implements Module {
    private static final Logger log = new Logger(ParametrizedUriEmitterModule.class);

    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "druid.emitter.parametrized", ParametrizedUriEmitterConfig.class);
        JsonConfigProvider.bind(binder, "druid.emitter.parametrized.httpEmitting", ParametrizedUriEmitterSSLClientConfig.class);
    }

    @Provides
    @ManageLifecycle
    @Named(value="parametrized")
    public Emitter getEmitter(Supplier<ParametrizedUriEmitterConfig> config, Supplier<ParametrizedUriEmitterSSLClientConfig> parametrizedSSLClientConfig, @Nullable SSLContext sslContext, Lifecycle lifecycle, ObjectMapper jsonMapper) {
        HttpEmitterSSLClientConfig sslConfig = parametrizedSSLClientConfig.get().getHttpEmittingSSLClientConfig();
        return new ParametrizedUriEmitter(config.get(), lifecycle.addCloseableInstance(HttpEmitterModule.createAsyncHttpClient("ParmetrizedUriEmitter-AsyncHttpClient-%d", "ParmetrizedUriEmitter-AsyncHttpClient-Timer-%d", HttpEmitterModule.getEffectiveSSLContext(sslConfig, sslContext))), jsonMapper);
    }
}

