/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.helper;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.hive.druid.org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.JodaUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.hive.druid.org.apache.druid.server.coordinator.helper.CompactionSegmentIterator;
import org.apache.hive.druid.org.apache.druid.timeline.CompactionState;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.Partitions;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

public class NewestSegmentFirstIterator
implements CompactionSegmentIterator {
    private static final Logger log = new Logger(NewestSegmentFirstIterator.class);
    private final ObjectMapper objectMapper;
    private final Map<String, DataSourceCompactionConfig> compactionConfigs;
    private final Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources;
    private final Map<String, CompactibleTimelineObjectHolderCursor> timelineIterators;
    private final PriorityQueue<QueueEntry> queue = new PriorityQueue((o1, o2) -> Comparators.intervalsByStartThenEnd().compare(((QueueEntry)o2).interval, ((QueueEntry)o1).interval));

    NewestSegmentFirstIterator(ObjectMapper objectMapper, Map<String, DataSourceCompactionConfig> compactionConfigs, Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources, Map<String, List<Interval>> skipIntervals) {
        this.objectMapper = objectMapper;
        this.compactionConfigs = compactionConfigs;
        this.dataSources = dataSources;
        this.timelineIterators = new HashMap<String, CompactibleTimelineObjectHolderCursor>(dataSources.size());
        dataSources.forEach((dataSource, timeline) -> {
            List<Interval> searchIntervals;
            DataSourceCompactionConfig config = (DataSourceCompactionConfig)compactionConfigs.get(dataSource);
            if (config != null && !timeline.isEmpty() && !(searchIntervals = NewestSegmentFirstIterator.findInitialSearchInterval(timeline, config.getSkipOffsetFromLatest(), (List)skipIntervals.get(dataSource))).isEmpty()) {
                this.timelineIterators.put((String)dataSource, new CompactibleTimelineObjectHolderCursor((VersionedIntervalTimeline<String, DataSegment>)timeline, searchIntervals));
            }
        });
        compactionConfigs.forEach((dataSourceName, config) -> {
            if (config == null) {
                throw new ISE("Unknown dataSource[%s]", dataSourceName);
            }
            this.updateQueue((String)dataSourceName, (DataSourceCompactionConfig)config);
        });
    }

    @Override
    public Object2LongOpenHashMap<String> remainingSegmentSizeBytes() {
        Object2LongOpenHashMap<String> resultMap = new Object2LongOpenHashMap<String>();
        resultMap.defaultReturnValue(-1L);
        for (QueueEntry entry : this.queue) {
            VersionedIntervalTimeline<String, DataSegment> timeline = this.dataSources.get(entry.getDataSource());
            Interval interval = new Interval((ReadableInstant)timeline.first().getInterval().getStart(), (ReadableInstant)entry.interval.getEnd());
            List<TimelineObjectHolder<String, DataSegment>> holders = timeline.lookup(interval);
            resultMap.put(entry.getDataSource(), holders.stream().flatMap(holder -> StreamSupport.stream(holder.getObject().spliterator(), false)).mapToLong(chunk -> ((DataSegment)chunk.getObject()).getSize()).sum());
        }
        return resultMap;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public List<DataSegment> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QueueEntry entry = this.queue.poll();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        List resultSegments = entry.segments;
        Preconditions.checkState(!resultSegments.isEmpty(), "Queue entry must not be empty");
        String dataSource = ((DataSegment)resultSegments.get(0)).getDataSource();
        this.updateQueue(dataSource, this.compactionConfigs.get(dataSource));
        return resultSegments;
    }

    private void updateQueue(String dataSourceName, DataSourceCompactionConfig config) {
        CompactibleTimelineObjectHolderCursor compactibleTimelineObjectHolderCursor = this.timelineIterators.get(dataSourceName);
        if (compactibleTimelineObjectHolderCursor == null) {
            log.warn("Cannot find timeline for dataSource[%s]. Skip this dataSource", dataSourceName);
            return;
        }
        SegmentsToCompact segmentsToCompact = this.findSegmentsToCompact(compactibleTimelineObjectHolderCursor, config);
        if (!segmentsToCompact.isEmpty()) {
            this.queue.add(new QueueEntry(segmentsToCompact.segments));
        }
    }

    private boolean needsCompaction(DataSourceCompactionConfig config, SegmentsToCompact candidates) {
        Preconditions.checkState(!candidates.isEmpty(), "Empty candidates");
        int maxRowsPerSegment = config.getMaxRowsPerSegment() == null ? 5000000 : config.getMaxRowsPerSegment();
        Long maxTotalRows = config.getTuningConfig() == null ? null : config.getTuningConfig().getMaxTotalRows();
        maxTotalRows = maxTotalRows == null ? Long.MAX_VALUE : maxTotalRows;
        CompactionState lastCompactionState = ((DataSegment)candidates.segments.get(0)).getLastCompactionState();
        if (lastCompactionState == null) {
            log.info("Candidate segment[%s] is not compacted yet. Needs compaction.", candidates.segments.get(0));
            return true;
        }
        boolean allCandidatesHaveSameLastCompactionState = candidates.segments.stream().allMatch(segment -> lastCompactionState.equals(segment.getLastCompactionState()));
        if (!allCandidatesHaveSameLastCompactionState) {
            log.info("Candidates[%s] were compacted with different partitions spec. Needs compaction.", candidates.segments);
            return true;
        }
        PartitionsSpec segmentPartitionsSpec = lastCompactionState.getPartitionsSpec();
        if (!(segmentPartitionsSpec instanceof DynamicPartitionsSpec)) {
            log.info("Candidate segment[%s] was compacted with a non dynamic partitions spec. Needs compaction.", candidates.segments.get(0));
            return true;
        }
        DynamicPartitionsSpec dynamicPartitionsSpec = (DynamicPartitionsSpec)segmentPartitionsSpec;
        IndexSpec segmentIndexSpec = this.objectMapper.convertValue(lastCompactionState.getIndexSpec(), IndexSpec.class);
        IndexSpec configuredIndexSpec = config.getTuningConfig() == null || config.getTuningConfig().getIndexSpec() == null ? new IndexSpec() : config.getTuningConfig().getIndexSpec();
        boolean needsCompaction = false;
        if (!Objects.equals(maxRowsPerSegment, dynamicPartitionsSpec.getMaxRowsPerSegment()) || !Objects.equals(maxTotalRows, dynamicPartitionsSpec.getMaxTotalRows())) {
            log.info("Configured maxRowsPerSegment[%s] and maxTotalRows[%s] are differenet from the partitionsSpec[%s] of segments. Needs compaction.", maxRowsPerSegment, maxTotalRows, dynamicPartitionsSpec);
            needsCompaction = true;
        }
        if (!segmentIndexSpec.equals(configuredIndexSpec)) {
            log.info("Configured indexSpec[%s] is different from the one[%s] of segments. Needs compaction", configuredIndexSpec, segmentIndexSpec);
            needsCompaction = true;
        }
        return needsCompaction;
    }

    private SegmentsToCompact findSegmentsToCompact(CompactibleTimelineObjectHolderCursor compactibleTimelineObjectHolderCursor, DataSourceCompactionConfig config) {
        long inputSegmentSize = config.getInputSegmentSizeBytes();
        while (compactibleTimelineObjectHolderCursor.hasNext()) {
            SegmentsToCompact candidates = new SegmentsToCompact((List)compactibleTimelineObjectHolderCursor.next());
            if (!candidates.isEmpty()) {
                boolean isCompactibleSize = candidates.getTotalSize() <= inputSegmentSize;
                boolean needsCompaction = this.needsCompaction(config, candidates);
                if (isCompactibleSize && needsCompaction) {
                    return candidates;
                }
                if (isCompactibleSize) continue;
                log.warn("total segment size[%d] for datasource[%s] and interval[%s] is larger than inputSegmentSize[%d]. Continue to the next interval.", candidates.getTotalSize(), ((DataSegment)candidates.segments.get(0)).getDataSource(), ((DataSegment)candidates.segments.get(0)).getInterval(), inputSegmentSize);
                continue;
            }
            throw new ISE("No segment is found?", new Object[0]);
        }
        log.info("All segments look good! Nothing to compact", new Object[0]);
        return new SegmentsToCompact();
    }

    private static List<Interval> findInitialSearchInterval(VersionedIntervalTimeline<String, DataSegment> timeline, Period skipOffset, @Nullable List<Interval> skipIntervals) {
        Preconditions.checkArgument(timeline != null && !timeline.isEmpty(), "timeline should not be null or empty");
        Preconditions.checkNotNull(skipOffset, "skipOffset");
        TimelineObjectHolder<String, DataSegment> first = Preconditions.checkNotNull(timeline.first(), "first");
        TimelineObjectHolder<String, DataSegment> last = Preconditions.checkNotNull(timeline.last(), "last");
        List<Interval> fullSkipIntervals = NewestSegmentFirstIterator.sortAndAddSkipIntervalFromLatest(last.getInterval().getEnd(), skipOffset, skipIntervals);
        Interval totalInterval = new Interval((ReadableInstant)first.getInterval().getStart(), (ReadableInstant)last.getInterval().getEnd());
        List<Interval> filteredInterval = NewestSegmentFirstIterator.filterSkipIntervals(totalInterval, fullSkipIntervals);
        ArrayList<Interval> searchIntervals = new ArrayList<Interval>();
        for (Interval lookupInterval : filteredInterval) {
            List segments = timeline.findNonOvershadowedObjectsInInterval(lookupInterval, Partitions.ONLY_COMPLETE).stream().filter(segment -> lookupInterval.contains((ReadableInterval)segment.getInterval())).collect(Collectors.toList());
            if (segments.isEmpty()) continue;
            DateTime searchStart = segments.stream().map(segment -> segment.getId().getIntervalStart()).min(Comparator.naturalOrder()).orElseThrow(AssertionError::new);
            DateTime searchEnd = segments.stream().map(segment -> segment.getId().getIntervalEnd()).max(Comparator.naturalOrder()).orElseThrow(AssertionError::new);
            searchIntervals.add(new Interval((ReadableInstant)searchStart, (ReadableInstant)searchEnd));
        }
        return searchIntervals;
    }

    @VisibleForTesting
    static List<Interval> sortAndAddSkipIntervalFromLatest(DateTime latest, Period skipOffset, @Nullable List<Interval> skipIntervals) {
        ArrayList<Interval> nonNullSkipIntervals;
        ArrayList<Object> arrayList = nonNullSkipIntervals = skipIntervals == null ? new ArrayList<Interval>(1) : new ArrayList(skipIntervals.size());
        if (skipIntervals != null) {
            ArrayList<Interval> sortedSkipIntervals = new ArrayList<Interval>(skipIntervals);
            sortedSkipIntervals.sort(Comparators.intervalsByStartThenEnd());
            ArrayList<Interval> overlapIntervals = new ArrayList<Interval>();
            Interval skipFromLatest = new Interval((ReadablePeriod)skipOffset, (ReadableInstant)latest);
            for (Interval interval : sortedSkipIntervals) {
                if (interval.overlaps((ReadableInterval)skipFromLatest)) {
                    overlapIntervals.add(interval);
                    continue;
                }
                nonNullSkipIntervals.add(interval);
            }
            if (!overlapIntervals.isEmpty()) {
                overlapIntervals.add(skipFromLatest);
                nonNullSkipIntervals.add(JodaUtils.umbrellaInterval(overlapIntervals));
            } else {
                nonNullSkipIntervals.add(skipFromLatest);
            }
        } else {
            Interval skipFromLatest = new Interval((ReadablePeriod)skipOffset, (ReadableInstant)latest);
            nonNullSkipIntervals.add(skipFromLatest);
        }
        return nonNullSkipIntervals;
    }

    @VisibleForTesting
    static List<Interval> filterSkipIntervals(Interval totalInterval, List<Interval> skipIntervals) {
        ArrayList<Interval> filteredIntervals = new ArrayList<Interval>(skipIntervals.size() + 1);
        DateTime remainingStart = totalInterval.getStart();
        DateTime remainingEnd = totalInterval.getEnd();
        for (Interval skipInterval : skipIntervals) {
            if (skipInterval.getStart().isBefore((ReadableInstant)remainingStart) && skipInterval.getEnd().isAfter((ReadableInstant)remainingStart)) {
                remainingStart = skipInterval.getEnd();
                continue;
            }
            if (skipInterval.getStart().isBefore((ReadableInstant)remainingEnd) && skipInterval.getEnd().isAfter((ReadableInstant)remainingEnd)) {
                remainingEnd = skipInterval.getStart();
                continue;
            }
            if (!remainingStart.isAfter((ReadableInstant)skipInterval.getStart()) && !remainingEnd.isBefore((ReadableInstant)skipInterval.getEnd())) {
                filteredIntervals.add(new Interval((ReadableInstant)remainingStart, (ReadableInstant)skipInterval.getStart()));
                remainingStart = skipInterval.getEnd();
                continue;
            }
            log.warn("skipInterval[%s] is not contained in remainingInterval[%s]", skipInterval, new Interval((ReadableInstant)remainingStart, (ReadableInstant)remainingEnd));
        }
        if (!remainingStart.equals((Object)remainingEnd)) {
            filteredIntervals.add(new Interval((ReadableInstant)remainingStart, (ReadableInstant)remainingEnd));
        }
        return filteredIntervals;
    }

    private static class SegmentsToCompact {
        private final List<DataSegment> segments;
        private final long totalSize;

        private SegmentsToCompact() {
            this(Collections.emptyList());
        }

        private SegmentsToCompact(List<DataSegment> segments) {
            this.segments = segments;
            this.totalSize = segments.stream().mapToLong(DataSegment::getSize).sum();
        }

        private boolean isEmpty() {
            return this.segments.isEmpty();
        }

        private int getNumSegments() {
            return this.segments.size();
        }

        private long getTotalSize() {
            return this.totalSize;
        }

        public String toString() {
            return "SegmentsToCompact{segments=" + this.segments + ", totalSize=" + this.totalSize + '}';
        }
    }

    private static class QueueEntry {
        private final Interval interval;
        private final List<DataSegment> segments;

        private QueueEntry(List<DataSegment> segments) {
            Preconditions.checkArgument(segments != null && !segments.isEmpty());
            Collections.sort(segments);
            this.interval = new Interval((ReadableInstant)segments.get(0).getInterval().getStart(), (ReadableInstant)segments.get(segments.size() - 1).getInterval().getEnd());
            this.segments = segments;
        }

        private String getDataSource() {
            return this.segments.get(0).getDataSource();
        }
    }

    private static class CompactibleTimelineObjectHolderCursor
    implements Iterator<List<DataSegment>> {
        private final List<TimelineObjectHolder<String, DataSegment>> holders;

        CompactibleTimelineObjectHolderCursor(VersionedIntervalTimeline<String, DataSegment> timeline, List<Interval> totalIntervalsToSearch) {
            this.holders = totalIntervalsToSearch.stream().flatMap(interval -> timeline.lookup((Interval)interval).stream().filter(holder -> this.isCompactibleHolder((Interval)interval, (TimelineObjectHolder<String, DataSegment>)holder))).collect(Collectors.toList());
        }

        private boolean isCompactibleHolder(Interval interval, TimelineObjectHolder<String, DataSegment> holder) {
            long partitionBytes;
            Iterator<PartitionChunk<DataSegment>> chunks = holder.getObject().iterator();
            if (!chunks.hasNext()) {
                return false;
            }
            PartitionChunk<DataSegment> firstChunk = chunks.next();
            if (!interval.contains((ReadableInterval)firstChunk.getObject().getInterval())) {
                return false;
            }
            for (partitionBytes = firstChunk.getObject().getSize(); partitionBytes == 0L && chunks.hasNext(); partitionBytes += chunks.next().getObject().getSize()) {
            }
            return partitionBytes > 0L;
        }

        @Override
        public boolean hasNext() {
            return !this.holders.isEmpty();
        }

        @Override
        public List<DataSegment> next() {
            if (this.holders.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.holders.remove(this.holders.size() - 1).getObject().stream().map(PartitionChunk::getObject).collect(Collectors.toList());
        }
    }
}

