/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.helper;

import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.JodaUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataSegmentManager;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.joda.time.Interval;

public class DruidCoordinatorSegmentKiller
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorSegmentKiller.class);
    private final long period;
    private final long retainDuration;
    private final int maxSegmentsToKill;
    private long lastKillTime = 0L;
    private final MetadataSegmentManager segmentsMetadata;
    private final IndexingServiceClient indexingServiceClient;

    @Inject
    public DruidCoordinatorSegmentKiller(MetadataSegmentManager segmentsMetadata, IndexingServiceClient indexingServiceClient, DruidCoordinatorConfig config) {
        this.period = config.getCoordinatorKillPeriod().getMillis();
        Preconditions.checkArgument(this.period > config.getCoordinatorIndexingPeriod().getMillis(), "coordinator kill period must be greater than druid.coordinator.period.indexingPeriod");
        this.retainDuration = config.getCoordinatorKillDurationToRetain().getMillis();
        Preconditions.checkArgument(this.retainDuration >= 0L, "coordinator kill retainDuration must be >= 0");
        this.maxSegmentsToKill = config.getCoordinatorKillMaxSegments();
        Preconditions.checkArgument(this.maxSegmentsToKill > 0, "coordinator kill maxSegments must be > 0");
        log.info("Kill Task scheduling enabled with period [%s], retainDuration [%s], maxSegmentsToKill [%s]", this.period, this.retainDuration, this.maxSegmentsToKill);
        this.segmentsMetadata = segmentsMetadata;
        this.indexingServiceClient = indexingServiceClient;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        boolean killAllDataSources = params.getCoordinatorDynamicConfig().isKillUnusedSegmentsInAllDataSources();
        Set<String> specificDataSourcesToKill = params.getCoordinatorDynamicConfig().getSpecificDataSourcesToKillUnusedSegmentsIn();
        if (killAllDataSources && specificDataSourcesToKill != null && !specificDataSourcesToKill.isEmpty()) {
            log.error("killAllDataSources can't be true when specificDataSourcesToKill is non-empty. No kill tasks are scheduled.", new Object[0]);
            return params;
        }
        Set<String> dataSourcesToKill = specificDataSourcesToKill;
        if (killAllDataSources) {
            dataSourcesToKill = this.segmentsMetadata.retrieveAllDataSourceNames();
        }
        if (dataSourcesToKill != null && dataSourcesToKill.size() > 0 && this.lastKillTime + this.period < System.currentTimeMillis()) {
            this.lastKillTime = System.currentTimeMillis();
            for (String dataSource : dataSourcesToKill) {
                Interval intervalToKill = this.findIntervalForKill(dataSource, this.maxSegmentsToKill);
                if (intervalToKill == null) continue;
                try {
                    this.indexingServiceClient.killSegments(dataSource, intervalToKill);
                }
                catch (Exception ex) {
                    log.error(ex, "Failed to submit kill task for dataSource [%s]", dataSource);
                    if (!Thread.currentThread().isInterrupted()) continue;
                    log.warn("skipping kill task scheduling because thread is interrupted.", new Object[0]);
                    break;
                }
            }
        }
        return params;
    }

    @Nullable
    @VisibleForTesting
    Interval findIntervalForKill(String dataSource, int limit) {
        List<Interval> unusedSegmentIntervals = this.segmentsMetadata.getUnusedSegmentIntervals(dataSource, DateTimes.nowUtc().minus(this.retainDuration), limit);
        if (unusedSegmentIntervals != null && unusedSegmentIntervals.size() > 0) {
            return JodaUtils.umbrellaInterval(unusedSegmentIntervals);
        }
        return null;
    }
}

