/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.cost;

import java.util.HashMap;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.server.coordinator.cost.SegmentsCostCache;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.utils.CollectionUtils;

public class ServerCostCache {
    private final SegmentsCostCache allSegmentsCostCache;
    private final Map<String, SegmentsCostCache> segmentsPerDataSource;

    ServerCostCache(SegmentsCostCache allSegmentsCostCache, Map<String, SegmentsCostCache> segmentsCostPerDataSource) {
        this.allSegmentsCostCache = Preconditions.checkNotNull(allSegmentsCostCache);
        this.segmentsPerDataSource = Preconditions.checkNotNull(segmentsCostPerDataSource);
    }

    double computeCost(DataSegment segment) {
        return this.allSegmentsCostCache.cost(segment) + this.computeDataSourceCost(segment);
    }

    private double computeDataSourceCost(DataSegment segment) {
        SegmentsCostCache costCache = this.segmentsPerDataSource.get(segment.getDataSource());
        return costCache == null ? 0.0 : costCache.cost(segment);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SegmentsCostCache.Builder allSegmentsCostCache = SegmentsCostCache.builder();
        private final Map<String, SegmentsCostCache.Builder> segmentsPerDataSource = new HashMap<String, SegmentsCostCache.Builder>();

        public Builder addSegment(DataSegment dataSegment) {
            this.allSegmentsCostCache.addSegment(dataSegment);
            this.segmentsPerDataSource.computeIfAbsent(dataSegment.getDataSource(), d -> SegmentsCostCache.builder()).addSegment(dataSegment);
            return this;
        }

        public Builder removeSegment(DataSegment dataSegment) {
            this.allSegmentsCostCache.removeSegment(dataSegment);
            this.segmentsPerDataSource.computeIfPresent(dataSegment.getDataSource(), (ds, builder) -> builder.removeSegment(dataSegment).isEmpty() ? null : builder);
            return this;
        }

        public boolean isEmpty() {
            return this.allSegmentsCostCache.isEmpty();
        }

        public ServerCostCache build() {
            return new ServerCostCache(this.allSegmentsCostCache.build(), CollectionUtils.mapValues(this.segmentsPerDataSource, SegmentsCostCache.Builder::build));
        }
    }
}

