/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator;

import org.joda.time.Duration;
import org.skife.config.Config;
import org.skife.config.Default;

public abstract class DruidCoordinatorConfig {
    @Config(value={"druid.coordinator.startDelay"})
    @Default(value="PT300s")
    public abstract Duration getCoordinatorStartDelay();

    @Config(value={"druid.coordinator.period"})
    @Default(value="PT60s")
    public abstract Duration getCoordinatorPeriod();

    @Config(value={"druid.coordinator.period.indexingPeriod"})
    @Default(value="PT1800s")
    public abstract Duration getCoordinatorIndexingPeriod();

    @Config(value={"druid.coordinator.kill.period"})
    @Default(value="P1D")
    public abstract Duration getCoordinatorKillPeriod();

    @Config(value={"druid.coordinator.kill.durationToRetain"})
    @Default(value="PT-1s")
    public abstract Duration getCoordinatorKillDurationToRetain();

    @Config(value={"druid.coordinator.kill.maxSegments"})
    @Default(value="0")
    public abstract int getCoordinatorKillMaxSegments();

    @Config(value={"druid.coordinator.load.timeout"})
    public Duration getLoadTimeoutDelay() {
        return new Duration(900000L);
    }

    @Config(value={"druid.coordinator.loadqueuepeon.repeatDelay"})
    public Duration getLoadQueuePeonRepeatDelay() {
        return Duration.millis((long)50L);
    }

    @Config(value={"druid.coordinator.loadqueuepeon.type"})
    public String getLoadQueuePeonType() {
        return "curator";
    }

    @Config(value={"druid.coordinator.curator.loadqueuepeon.numCallbackThreads"})
    public int getNumCuratorCallBackThreads() {
        return 2;
    }

    @Config(value={"druid.coordinator.loadqueuepeon.http.repeatDelay"})
    public Duration getHttpLoadQueuePeonRepeatDelay() {
        return Duration.millis((long)60000L);
    }

    @Config(value={"druid.coordinator.loadqueuepeon.http.hostTimeout"})
    public Duration getHttpLoadQueuePeonHostTimeout() {
        return Duration.millis((long)300000L);
    }

    @Config(value={"druid.coordinator.loadqueuepeon.http.batchSize"})
    public int getHttpLoadQueuePeonBatchSize() {
        return 1;
    }
}

