/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.ObjLongConsumer;

public class CoordinatorStats {
    private final Map<String, Object2LongOpenHashMap<String>> perTierStats = new HashMap<String, Object2LongOpenHashMap<String>>();
    private final Map<String, Object2LongOpenHashMap<String>> perDataSourceStats = new HashMap<String, Object2LongOpenHashMap<String>>();
    private final Object2LongOpenHashMap<String> globalStats = new Object2LongOpenHashMap();

    public boolean hasPerTierStats() {
        return !this.perTierStats.isEmpty();
    }

    public boolean hasPerDataSourceStats() {
        return !this.perDataSourceStats.isEmpty();
    }

    public Set<String> getTiers(String statName) {
        Object2LongOpenHashMap<String> theStat = this.perTierStats.get(statName);
        if (theStat == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(theStat.keySet());
    }

    public Set<String> getDataSources(String statName) {
        Object2LongOpenHashMap<String> stat = this.perDataSourceStats.get(statName);
        if (stat == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(stat.keySet());
    }

    public long getTieredStat(String statName, String tier) {
        return this.perTierStats.get(statName).getLong(tier);
    }

    public void forEachTieredStat(String statName, ObjLongConsumer<String> consumer) {
        Object2LongOpenHashMap<String> theStat = this.perTierStats.get(statName);
        if (theStat != null) {
            for (Object2LongMap.Entry entry : theStat.object2LongEntrySet()) {
                consumer.accept((String)entry.getKey(), entry.getLongValue());
            }
        }
    }

    public long getDataSourceStat(String statName, String dataSource) {
        return this.perDataSourceStats.get(statName).getLong(dataSource);
    }

    public void forEachDataSourceStat(String statName, ObjLongConsumer<String> consumer) {
        Object2LongOpenHashMap<String> stat = this.perDataSourceStats.get(statName);
        if (stat != null) {
            for (Object2LongMap.Entry entry : stat.object2LongEntrySet()) {
                consumer.accept((String)entry.getKey(), entry.getLongValue());
            }
        }
    }

    public long getGlobalStat(String statName) {
        return this.globalStats.getLong(statName);
    }

    public void addToTieredStat(String statName, String tier, long value) {
        this.perTierStats.computeIfAbsent(statName, ignored -> new Object2LongOpenHashMap()).addTo(tier, value);
    }

    public void accumulateMaxTieredStat(String statName, String tier, long value) {
        this.perTierStats.computeIfAbsent(statName, ignored -> new Object2LongOpenHashMap()).mergeLong(tier, value, Math::max);
    }

    public void addToDataSourceStat(String statName, String dataSource, long value) {
        this.perDataSourceStats.computeIfAbsent(statName, k -> new Object2LongOpenHashMap()).addTo(dataSource, value);
    }

    public void addToGlobalStat(String statName, long value) {
        this.globalStats.addTo(statName, value);
    }

    public CoordinatorStats accumulate(CoordinatorStats stats) {
        stats.perTierStats.forEach((statName, urStat) -> {
            Object2LongOpenHashMap myStat = this.perTierStats.computeIfAbsent((String)statName, name -> new Object2LongOpenHashMap());
            for (Object2LongMap.Entry entry : urStat.object2LongEntrySet()) {
                myStat.addTo(entry.getKey(), entry.getLongValue());
            }
        });
        stats.perDataSourceStats.forEach((statName, urStat) -> {
            Object2LongOpenHashMap myStat = this.perDataSourceStats.computeIfAbsent((String)statName, k -> new Object2LongOpenHashMap());
            for (Object2LongMap.Entry entry : urStat.object2LongEntrySet()) {
                myStat.addTo(entry.getKey(), entry.getLongValue());
            }
        });
        for (Object2LongMap.Entry entry : stats.globalStats.object2LongEntrySet()) {
            this.globalStats.addTo((String)entry.getKey(), entry.getLongValue());
        }
        return this;
    }
}

