/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.common.config.JacksonConfigManager;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;

public class CoordinatorDynamicConfig {
    public static final String CONFIG_KEY = "coordinator.config";
    private final long leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments;
    private final long mergeBytesLimit;
    private final int mergeSegmentsLimit;
    private final int maxSegmentsToMove;
    private final int replicantLifetime;
    private final int replicationThrottleLimit;
    private final int balancerComputeThreads;
    private final boolean emitBalancingStats;
    private final boolean killUnusedSegmentsInAllDataSources;
    private final Set<String> specificDataSourcesToKillUnusedSegmentsIn;
    private final Set<String> decommissioningNodes;
    private final int decommissioningMaxPercentOfMaxSegmentsToMove;
    private final Set<String> dataSourcesToNotKillStalePendingSegmentsIn;
    private final int maxSegmentsInNodeLoadingQueue;

    @JsonCreator
    public CoordinatorDynamicConfig(@JsonProperty(value="millisToWaitBeforeDeleting") long leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, @JsonProperty(value="mergeBytesLimit") long mergeBytesLimit, @JsonProperty(value="mergeSegmentsLimit") int mergeSegmentsLimit, @JsonProperty(value="maxSegmentsToMove") int maxSegmentsToMove, @JsonProperty(value="replicantLifetime") int replicantLifetime, @JsonProperty(value="replicationThrottleLimit") int replicationThrottleLimit, @JsonProperty(value="balancerComputeThreads") int balancerComputeThreads, @JsonProperty(value="emitBalancingStats") boolean emitBalancingStats, @JsonProperty(value="killDataSourceWhitelist") Object specificDataSourcesToKillUnusedSegmentsIn, @JsonProperty(value="killAllDataSources") boolean killUnusedSegmentsInAllDataSources, @JsonProperty(value="killPendingSegmentsSkipList") Object dataSourcesToNotKillStalePendingSegmentsIn, @JsonProperty(value="maxSegmentsInNodeLoadingQueue") int maxSegmentsInNodeLoadingQueue, @JsonProperty(value="decommissioningNodes") Object decommissioningNodes, @JsonProperty(value="decommissioningMaxPercentOfMaxSegmentsToMove") int decommissioningMaxPercentOfMaxSegmentsToMove) {
        this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments = leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments;
        this.mergeBytesLimit = mergeBytesLimit;
        this.mergeSegmentsLimit = mergeSegmentsLimit;
        this.maxSegmentsToMove = maxSegmentsToMove;
        this.replicantLifetime = replicantLifetime;
        this.replicationThrottleLimit = replicationThrottleLimit;
        this.balancerComputeThreads = Math.max(balancerComputeThreads, 1);
        this.emitBalancingStats = emitBalancingStats;
        this.killUnusedSegmentsInAllDataSources = killUnusedSegmentsInAllDataSources;
        this.specificDataSourcesToKillUnusedSegmentsIn = CoordinatorDynamicConfig.parseJsonStringOrArray(specificDataSourcesToKillUnusedSegmentsIn);
        this.dataSourcesToNotKillStalePendingSegmentsIn = CoordinatorDynamicConfig.parseJsonStringOrArray(dataSourcesToNotKillStalePendingSegmentsIn);
        this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
        this.decommissioningNodes = CoordinatorDynamicConfig.parseJsonStringOrArray(decommissioningNodes);
        Preconditions.checkArgument(decommissioningMaxPercentOfMaxSegmentsToMove >= 0 && decommissioningMaxPercentOfMaxSegmentsToMove <= 100, "decommissioningMaxPercentOfMaxSegmentsToMove should be in range [0, 100]");
        this.decommissioningMaxPercentOfMaxSegmentsToMove = decommissioningMaxPercentOfMaxSegmentsToMove;
        if (this.killUnusedSegmentsInAllDataSources && !this.specificDataSourcesToKillUnusedSegmentsIn.isEmpty()) {
            throw new IAE("can't have killUnusedSegmentsInAllDataSources and non-empty specificDataSourcesToKillUnusedSegmentsIn", new Object[0]);
        }
    }

    private static Set<String> parseJsonStringOrArray(Object jsonStringOrArray) {
        if (jsonStringOrArray instanceof String) {
            String[] list = ((String)jsonStringOrArray).split(",");
            HashSet<String> result = new HashSet<String>();
            for (String item : list) {
                String trimmed = item.trim();
                if (trimmed.isEmpty()) continue;
                result.add(trimmed);
            }
            return result;
        }
        if (jsonStringOrArray instanceof Collection) {
            return ImmutableSet.copyOf((Collection)jsonStringOrArray);
        }
        return ImmutableSet.of();
    }

    public static AtomicReference<CoordinatorDynamicConfig> watch(JacksonConfigManager configManager) {
        return configManager.watch(CONFIG_KEY, CoordinatorDynamicConfig.class, CoordinatorDynamicConfig.builder().build());
    }

    @Nonnull
    public static CoordinatorDynamicConfig current(JacksonConfigManager configManager) {
        return Preconditions.checkNotNull(CoordinatorDynamicConfig.watch(configManager).get(), "Got null config from watcher?!");
    }

    @JsonProperty(value="millisToWaitBeforeDeleting")
    public long getLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments() {
        return this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments;
    }

    @JsonProperty
    public long getMergeBytesLimit() {
        return this.mergeBytesLimit;
    }

    @JsonProperty
    public boolean emitBalancingStats() {
        return this.emitBalancingStats;
    }

    @JsonProperty
    public int getMergeSegmentsLimit() {
        return this.mergeSegmentsLimit;
    }

    @JsonProperty
    public int getMaxSegmentsToMove() {
        return this.maxSegmentsToMove;
    }

    @JsonProperty
    public int getReplicantLifetime() {
        return this.replicantLifetime;
    }

    @JsonProperty
    public int getReplicationThrottleLimit() {
        return this.replicationThrottleLimit;
    }

    @JsonProperty
    public int getBalancerComputeThreads() {
        return this.balancerComputeThreads;
    }

    @JsonProperty(value="killDataSourceWhitelist")
    public Set<String> getSpecificDataSourcesToKillUnusedSegmentsIn() {
        return this.specificDataSourcesToKillUnusedSegmentsIn;
    }

    @JsonProperty(value="killAllDataSources")
    public boolean isKillUnusedSegmentsInAllDataSources() {
        return this.killUnusedSegmentsInAllDataSources;
    }

    @JsonProperty(value="killPendingSegmentsSkipList")
    public Set<String> getDataSourcesToNotKillStalePendingSegmentsIn() {
        return this.dataSourcesToNotKillStalePendingSegmentsIn;
    }

    @JsonProperty
    public int getMaxSegmentsInNodeLoadingQueue() {
        return this.maxSegmentsInNodeLoadingQueue;
    }

    @JsonProperty
    public Set<String> getDecommissioningNodes() {
        return this.decommissioningNodes;
    }

    @Min(value=0L)
    @Max(value=100L)
    @JsonProperty
    public int getDecommissioningMaxPercentOfMaxSegmentsToMove() {
        return this.decommissioningMaxPercentOfMaxSegmentsToMove;
    }

    public String toString() {
        return "CoordinatorDynamicConfig{leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments=" + this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments + ", mergeBytesLimit=" + this.mergeBytesLimit + ", mergeSegmentsLimit=" + this.mergeSegmentsLimit + ", maxSegmentsToMove=" + this.maxSegmentsToMove + ", replicantLifetime=" + this.replicantLifetime + ", replicationThrottleLimit=" + this.replicationThrottleLimit + ", balancerComputeThreads=" + this.balancerComputeThreads + ", emitBalancingStats=" + this.emitBalancingStats + ", killUnusedSegmentsInAllDataSources=" + this.killUnusedSegmentsInAllDataSources + ", specificDataSourcesToKillUnusedSegmentsIn=" + this.specificDataSourcesToKillUnusedSegmentsIn + ", dataSourcesToNotKillStalePendingSegmentsIn=" + this.dataSourcesToNotKillStalePendingSegmentsIn + ", maxSegmentsInNodeLoadingQueue=" + this.maxSegmentsInNodeLoadingQueue + ", decommissioningNodes=" + this.decommissioningNodes + ", decommissioningMaxPercentOfMaxSegmentsToMove=" + this.decommissioningMaxPercentOfMaxSegmentsToMove + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinatorDynamicConfig that = (CoordinatorDynamicConfig)o;
        if (this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments != that.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments) {
            return false;
        }
        if (this.mergeBytesLimit != that.mergeBytesLimit) {
            return false;
        }
        if (this.mergeSegmentsLimit != that.mergeSegmentsLimit) {
            return false;
        }
        if (this.maxSegmentsToMove != that.maxSegmentsToMove) {
            return false;
        }
        if (this.replicantLifetime != that.replicantLifetime) {
            return false;
        }
        if (this.replicationThrottleLimit != that.replicationThrottleLimit) {
            return false;
        }
        if (this.balancerComputeThreads != that.balancerComputeThreads) {
            return false;
        }
        if (this.emitBalancingStats != that.emitBalancingStats) {
            return false;
        }
        if (this.killUnusedSegmentsInAllDataSources != that.killUnusedSegmentsInAllDataSources) {
            return false;
        }
        if (this.maxSegmentsInNodeLoadingQueue != that.maxSegmentsInNodeLoadingQueue) {
            return false;
        }
        if (!Objects.equals(this.specificDataSourcesToKillUnusedSegmentsIn, that.specificDataSourcesToKillUnusedSegmentsIn)) {
            return false;
        }
        if (!Objects.equals(this.dataSourcesToNotKillStalePendingSegmentsIn, that.dataSourcesToNotKillStalePendingSegmentsIn)) {
            return false;
        }
        if (!Objects.equals(this.decommissioningNodes, that.decommissioningNodes)) {
            return false;
        }
        return this.decommissioningMaxPercentOfMaxSegmentsToMove == that.decommissioningMaxPercentOfMaxSegmentsToMove;
    }

    public int hashCode() {
        return Objects.hash(this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, this.mergeBytesLimit, this.mergeSegmentsLimit, this.maxSegmentsToMove, this.replicantLifetime, this.replicationThrottleLimit, this.balancerComputeThreads, this.emitBalancingStats, this.killUnusedSegmentsInAllDataSources, this.maxSegmentsInNodeLoadingQueue, this.specificDataSourcesToKillUnusedSegmentsIn, this.dataSourcesToNotKillStalePendingSegmentsIn, this.decommissioningNodes, this.decommissioningMaxPercentOfMaxSegmentsToMove);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final long DEFAULT_LEADING_TIME_MILLIS_BEFORE_CAN_MARK_AS_UNUSED_OVERSHADOWED_SEGMENTS = TimeUnit.MINUTES.toMillis(15L);
        private static final long DEFAULT_MERGE_BYTES_LIMIT = 524288000L;
        private static final int DEFAULT_MERGE_SEGMENTS_LIMIT = 100;
        private static final int DEFAULT_MAX_SEGMENTS_TO_MOVE = 5;
        private static final int DEFAULT_REPLICANT_LIFETIME = 15;
        private static final int DEFAULT_REPLICATION_THROTTLE_LIMIT = 10;
        private static final int DEFAULT_BALANCER_COMPUTE_THREADS = 1;
        private static final boolean DEFAULT_EMIT_BALANCING_STATS = false;
        private static final boolean DEFAULT_KILL_UNUSED_SEGMENTS_IN_ALL_DATA_SOURCES = false;
        private static final int DEFAULT_MAX_SEGMENTS_IN_NODE_LOADING_QUEUE = 0;
        private static final int DEFAULT_DECOMMISSIONING_MAX_SEGMENTS_TO_MOVE_PERCENT = 70;
        private Long leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments;
        private Long mergeBytesLimit;
        private Integer mergeSegmentsLimit;
        private Integer maxSegmentsToMove;
        private Integer replicantLifetime;
        private Integer replicationThrottleLimit;
        private Boolean emitBalancingStats;
        private Integer balancerComputeThreads;
        private Object specificDataSourcesToKillUnusedSegmentsIn;
        private Boolean killUnusedSegmentsInAllDataSources;
        private Object dataSourcesToNotKillStalePendingSegmentsIn;
        private Integer maxSegmentsInNodeLoadingQueue;
        private Object decommissioningNodes;
        private Integer decommissioningMaxPercentOfMaxSegmentsToMove;

        public Builder() {
        }

        @JsonCreator
        public Builder(@JsonProperty(value="millisToWaitBeforeDeleting") @Nullable Long leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, @JsonProperty(value="mergeBytesLimit") @Nullable Long mergeBytesLimit, @JsonProperty(value="mergeSegmentsLimit") @Nullable Integer mergeSegmentsLimit, @JsonProperty(value="maxSegmentsToMove") @Nullable Integer maxSegmentsToMove, @JsonProperty(value="replicantLifetime") @Nullable Integer replicantLifetime, @JsonProperty(value="replicationThrottleLimit") @Nullable Integer replicationThrottleLimit, @JsonProperty(value="balancerComputeThreads") @Nullable Integer balancerComputeThreads, @JsonProperty(value="emitBalancingStats") @Nullable Boolean emitBalancingStats, @JsonProperty(value="killDataSourceWhitelist") @Nullable Object specificDataSourcesToKillUnusedSegmentsIn, @JsonProperty(value="killAllDataSources") @Nullable Boolean killUnusedSegmentsInAllDataSources, @JsonProperty(value="killPendingSegmentsSkipList") @Nullable Object dataSourcesToNotKillStalePendingSegmentsIn, @JsonProperty(value="maxSegmentsInNodeLoadingQueue") @Nullable Integer maxSegmentsInNodeLoadingQueue, @JsonProperty(value="decommissioningNodes") @Nullable Object decommissioningNodes, @JsonProperty(value="decommissioningMaxPercentOfMaxSegmentsToMove") @Nullable Integer decommissioningMaxPercentOfMaxSegmentsToMove) {
            this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments = leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments;
            this.mergeBytesLimit = mergeBytesLimit;
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            this.maxSegmentsToMove = maxSegmentsToMove;
            this.replicantLifetime = replicantLifetime;
            this.replicationThrottleLimit = replicationThrottleLimit;
            this.balancerComputeThreads = balancerComputeThreads;
            this.emitBalancingStats = emitBalancingStats;
            this.specificDataSourcesToKillUnusedSegmentsIn = specificDataSourcesToKillUnusedSegmentsIn;
            this.killUnusedSegmentsInAllDataSources = killUnusedSegmentsInAllDataSources;
            this.dataSourcesToNotKillStalePendingSegmentsIn = dataSourcesToNotKillStalePendingSegmentsIn;
            this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
            this.decommissioningNodes = decommissioningNodes;
            this.decommissioningMaxPercentOfMaxSegmentsToMove = decommissioningMaxPercentOfMaxSegmentsToMove;
        }

        public Builder withLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments(long leadingTimeMillis) {
            this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments = leadingTimeMillis;
            return this;
        }

        public Builder withMergeBytesLimit(long mergeBytesLimit) {
            this.mergeBytesLimit = mergeBytesLimit;
            return this;
        }

        public Builder withMergeSegmentsLimit(int mergeSegmentsLimit) {
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            return this;
        }

        public Builder withMaxSegmentsToMove(int maxSegmentsToMove) {
            this.maxSegmentsToMove = maxSegmentsToMove;
            return this;
        }

        public Builder withReplicantLifetime(int replicantLifetime) {
            this.replicantLifetime = replicantLifetime;
            return this;
        }

        public Builder withReplicationThrottleLimit(int replicationThrottleLimit) {
            this.replicationThrottleLimit = replicationThrottleLimit;
            return this;
        }

        public Builder withBalancerComputeThreads(int balancerComputeThreads) {
            this.balancerComputeThreads = balancerComputeThreads;
            return this;
        }

        public Builder withEmitBalancingStats(boolean emitBalancingStats) {
            this.emitBalancingStats = emitBalancingStats;
            return this;
        }

        public Builder withSpecificDataSourcesToKillUnusedSegmentsIn(Set<String> dataSources) {
            this.specificDataSourcesToKillUnusedSegmentsIn = dataSources;
            return this;
        }

        public Builder withKillUnusedSegmentsInAllDataSources(boolean killUnusedSegmentsInAllDataSources) {
            this.killUnusedSegmentsInAllDataSources = killUnusedSegmentsInAllDataSources;
            return this;
        }

        public Builder withMaxSegmentsInNodeLoadingQueue(int maxSegmentsInNodeLoadingQueue) {
            this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
            return this;
        }

        public Builder withDecommissioningNodes(Set<String> decommissioning) {
            this.decommissioningNodes = decommissioning;
            return this;
        }

        public Builder withDecommissioningMaxPercentOfMaxSegmentsToMove(Integer percent) {
            this.decommissioningMaxPercentOfMaxSegmentsToMove = percent;
            return this;
        }

        public CoordinatorDynamicConfig build() {
            return new CoordinatorDynamicConfig(this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments == null ? DEFAULT_LEADING_TIME_MILLIS_BEFORE_CAN_MARK_AS_UNUSED_OVERSHADOWED_SEGMENTS : this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, this.mergeBytesLimit == null ? 524288000L : this.mergeBytesLimit, this.mergeSegmentsLimit == null ? 100 : this.mergeSegmentsLimit, this.maxSegmentsToMove == null ? 5 : this.maxSegmentsToMove, this.replicantLifetime == null ? 15 : this.replicantLifetime, this.replicationThrottleLimit == null ? 10 : this.replicationThrottleLimit, this.balancerComputeThreads == null ? 1 : this.balancerComputeThreads, this.emitBalancingStats == null ? false : this.emitBalancingStats, this.specificDataSourcesToKillUnusedSegmentsIn, this.killUnusedSegmentsInAllDataSources == null ? false : this.killUnusedSegmentsInAllDataSources, this.dataSourcesToNotKillStalePendingSegmentsIn, this.maxSegmentsInNodeLoadingQueue == null ? 0 : this.maxSegmentsInNodeLoadingQueue, this.decommissioningNodes, this.decommissioningMaxPercentOfMaxSegmentsToMove == null ? 70 : this.decommissioningMaxPercentOfMaxSegmentsToMove);
        }

        public CoordinatorDynamicConfig build(CoordinatorDynamicConfig defaults) {
            return new CoordinatorDynamicConfig(this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments == null ? defaults.getLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments() : this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments.longValue(), this.mergeBytesLimit == null ? defaults.getMergeBytesLimit() : this.mergeBytesLimit.longValue(), this.mergeSegmentsLimit == null ? defaults.getMergeSegmentsLimit() : this.mergeSegmentsLimit.intValue(), this.maxSegmentsToMove == null ? defaults.getMaxSegmentsToMove() : this.maxSegmentsToMove.intValue(), this.replicantLifetime == null ? defaults.getReplicantLifetime() : this.replicantLifetime.intValue(), this.replicationThrottleLimit == null ? defaults.getReplicationThrottleLimit() : this.replicationThrottleLimit.intValue(), this.balancerComputeThreads == null ? defaults.getBalancerComputeThreads() : this.balancerComputeThreads.intValue(), this.emitBalancingStats == null ? defaults.emitBalancingStats() : this.emitBalancingStats.booleanValue(), this.specificDataSourcesToKillUnusedSegmentsIn == null ? defaults.getSpecificDataSourcesToKillUnusedSegmentsIn() : this.specificDataSourcesToKillUnusedSegmentsIn, this.killUnusedSegmentsInAllDataSources == null ? defaults.isKillUnusedSegmentsInAllDataSources() : this.killUnusedSegmentsInAllDataSources.booleanValue(), this.dataSourcesToNotKillStalePendingSegmentsIn == null ? defaults.getDataSourcesToNotKillStalePendingSegmentsIn() : this.dataSourcesToNotKillStalePendingSegmentsIn, this.maxSegmentsInNodeLoadingQueue == null ? defaults.getMaxSegmentsInNodeLoadingQueue() : this.maxSegmentsInNodeLoadingQueue.intValue(), this.decommissioningNodes == null ? defaults.getDecommissioningNodes() : this.decommissioningNodes, this.decommissioningMaxPercentOfMaxSegmentsToMove == null ? defaults.getDecommissioningMaxPercentOfMaxSegmentsToMove() : this.decommissioningMaxPercentOfMaxSegmentsToMove.intValue());
        }
    }
}

