/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordination;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.org.apache.druid.concurrent.LifecycleLock;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.RE;
import org.apache.hive.druid.org.apache.druid.java.util.common.RetryUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.Request;
import org.apache.hive.druid.org.apache.druid.server.coordination.ChangeRequestHistory;
import org.apache.hive.druid.org.apache.druid.server.coordination.ChangeRequestsSnapshot;
import org.apache.hive.druid.org.apache.druid.server.coordinator.BytesAccumulatingResponseHandler;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Duration;

public class ChangeRequestHttpSyncer<T> {
    private static final EmittingLogger log = new EmittingLogger(ChangeRequestHttpSyncer.class);
    public static final long HTTP_TIMEOUT_EXTRA_MS = 5000L;
    private static final long MAX_RETRY_BACKOFF = TimeUnit.MINUTES.toMillis(2L);
    private final ObjectMapper smileMapper;
    private final HttpClient httpClient;
    private final ScheduledExecutorService executor;
    private final URL baseServerURL;
    private final String baseRequestPath;
    private final TypeReference<ChangeRequestsSnapshot<T>> responseTypeReferences;
    private final long serverTimeoutMS;
    private final long serverUnstabilityTimeout;
    private final long serverHttpTimeout;
    private final Listener<T> listener;
    private final CountDownLatch initializationLatch = new CountDownLatch(1);
    private final LifecycleLock startStopLock = new LifecycleLock();
    private final String logIdentity;
    private long unstableStartTime = -1L;
    private int consecutiveFailedAttemptCount = 0;
    private long lastSuccessfulSyncTime = 0L;
    private long lastSyncTime = 0L;
    @Nullable
    private ChangeRequestHistory.Counter counter = null;

    public ChangeRequestHttpSyncer(ObjectMapper smileMapper, HttpClient httpClient, ScheduledExecutorService executor, URL baseServerURL, String baseRequestPath, TypeReference<ChangeRequestsSnapshot<T>> responseTypeReferences, long serverTimeoutMS, long serverUnstabilityTimeout, Listener<T> listener) {
        this.smileMapper = smileMapper;
        this.httpClient = httpClient;
        this.executor = executor;
        this.baseServerURL = baseServerURL;
        this.baseRequestPath = baseRequestPath;
        this.responseTypeReferences = responseTypeReferences;
        this.serverTimeoutMS = serverTimeoutMS;
        this.serverUnstabilityTimeout = serverUnstabilityTimeout;
        this.serverHttpTimeout = serverTimeoutMS + 5000L;
        this.listener = listener;
        this.logIdentity = StringUtils.format("%s_%d", baseServerURL, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LifecycleLock lifecycleLock = this.startStopLock;
        synchronized (lifecycleLock) {
            if (!this.startStopLock.canStart()) {
                throw new ISE("Can't start ChangeRequestHttpSyncer[%s].", this.logIdentity);
            }
            log.info("Starting ChangeRequestHttpSyncer[%s].", this.logIdentity);
            this.startStopLock.started();
            this.startStopLock.exitStart();
            this.addNextSyncToWorkQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LifecycleLock lifecycleLock = this.startStopLock;
        synchronized (lifecycleLock) {
            if (!this.startStopLock.canStop()) {
                throw new ISE("Can't stop ChangeRequestHttpSyncer[%s].", this.logIdentity);
            }
            log.info("Stopped ChangeRequestHttpSyncer[%s].", this.logIdentity);
        }
    }

    public boolean awaitInitialization(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.initializationLatch.await(timeout, timeUnit);
    }

    public Map<String, Object> getDebugInfo() {
        long currTime = System.currentTimeMillis();
        Object notSuccessfullySyncedFor = this.lastSuccessfulSyncTime == 0L ? "Never Successfully Synced" : Long.valueOf((currTime - this.lastSuccessfulSyncTime) / 1000L);
        return ImmutableMap.of("notSyncedForSecs", this.lastSyncTime == 0L ? "Never Synced" : Long.valueOf((currTime - this.lastSyncTime) / 1000L), "notSuccessfullySyncedFor", notSuccessfullySyncedFor, "consecutiveFailedAttemptCount", this.consecutiveFailedAttemptCount, "syncScheduled", this.startStopLock.isStarted());
    }

    public boolean isOK() {
        return System.currentTimeMillis() - this.lastSyncTime < MAX_RETRY_BACKOFF + 3L * this.serverHttpTimeout;
    }

    public long getServerHttpTimeout() {
        return this.serverHttpTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        if (!this.startStopLock.awaitStarted(1L, TimeUnit.MILLISECONDS)) {
            log.info("Skipping sync() call for server[%s].", this.logIdentity);
            return;
        }
        this.lastSyncTime = System.currentTimeMillis();
        try {
            String req = this.getRequestString();
            final BytesAccumulatingResponseHandler responseHandler = new BytesAccumulatingResponseHandler();
            log.debug("Sending sync request to server[%s]", this.logIdentity);
            ListenableFuture<InputStream> syncRequestFuture = this.httpClient.go(new Request(HttpMethod.GET, new URL(this.baseServerURL, req)).addHeader("Accept", "application/x-jackson-smile").addHeader("Content-Type", "application/x-jackson-smile"), responseHandler, Duration.millis((long)this.serverHttpTimeout));
            log.debug("Sent sync request to [%s]", this.logIdentity);
            Futures.addCallback(syncRequestFuture, new FutureCallback<InputStream>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onSuccess(InputStream stream) {
                    LifecycleLock lifecycleLock = ChangeRequestHttpSyncer.this.startStopLock;
                    synchronized (lifecycleLock) {
                        if (!ChangeRequestHttpSyncer.this.startStopLock.awaitStarted(1L, TimeUnit.MILLISECONDS)) {
                            log.info("Skipping sync() success for server[%s].", ChangeRequestHttpSyncer.this.logIdentity);
                            return;
                        }
                        try {
                            if (responseHandler.getStatus() == 204) {
                                log.debug("Received NO CONTENT from server[%s]", ChangeRequestHttpSyncer.this.logIdentity);
                                ChangeRequestHttpSyncer.this.lastSuccessfulSyncTime = System.currentTimeMillis();
                                return;
                            }
                            if (responseHandler.getStatus() != 200) {
                                this.handleFailure(new RE("Bad Sync Response.", new Object[0]));
                                return;
                            }
                            log.debug("Received sync response from [%s]", ChangeRequestHttpSyncer.this.logIdentity);
                            ChangeRequestsSnapshot changes = (ChangeRequestsSnapshot)ChangeRequestHttpSyncer.this.smileMapper.readValue(stream, ChangeRequestHttpSyncer.this.responseTypeReferences);
                            log.debug("Finished reading sync response from [%s]", ChangeRequestHttpSyncer.this.logIdentity);
                            if (changes.isResetCounter()) {
                                log.info("[%s] requested resetCounter for reason [%s].", ChangeRequestHttpSyncer.this.logIdentity, changes.getResetCause());
                                ChangeRequestHttpSyncer.this.counter = null;
                                return;
                            }
                            if (ChangeRequestHttpSyncer.this.counter == null) {
                                ChangeRequestHttpSyncer.this.listener.fullSync(changes.getRequests());
                            } else {
                                ChangeRequestHttpSyncer.this.listener.deltaSync(changes.getRequests());
                            }
                            ChangeRequestHttpSyncer.this.counter = changes.getCounter();
                            if (ChangeRequestHttpSyncer.this.initializationLatch.getCount() > 0L) {
                                ChangeRequestHttpSyncer.this.initializationLatch.countDown();
                                log.info("[%s] synced successfully for the first time.", ChangeRequestHttpSyncer.this.logIdentity);
                            }
                            if (ChangeRequestHttpSyncer.this.consecutiveFailedAttemptCount > 0) {
                                ChangeRequestHttpSyncer.this.consecutiveFailedAttemptCount = 0;
                                log.info("[%s] synced successfully.", ChangeRequestHttpSyncer.this.logIdentity);
                            }
                            ChangeRequestHttpSyncer.this.lastSuccessfulSyncTime = System.currentTimeMillis();
                        }
                        catch (Exception ex) {
                            String logMsg = StringUtils.nonStrictFormat("Error processing sync response from [%s]. Reason [%s]", ChangeRequestHttpSyncer.this.logIdentity, ex.getMessage());
                            if (ChangeRequestHttpSyncer.this.incrementFailedAttemptAndCheckUnstabilityTimeout()) {
                                log.error(ex, logMsg, new Object[0]);
                            } else {
                                log.info("Temporary Failure. %s", logMsg);
                                log.debug(ex, logMsg, new Object[0]);
                            }
                        }
                        finally {
                            ChangeRequestHttpSyncer.this.addNextSyncToWorkQueue();
                        }
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Throwable t) {
                    LifecycleLock lifecycleLock = ChangeRequestHttpSyncer.this.startStopLock;
                    synchronized (lifecycleLock) {
                        if (!ChangeRequestHttpSyncer.this.startStopLock.awaitStarted(1L, TimeUnit.MILLISECONDS)) {
                            log.info("Skipping sync() failure for URL[%s].", ChangeRequestHttpSyncer.this.logIdentity);
                            return;
                        }
                        try {
                            this.handleFailure(t);
                        }
                        finally {
                            ChangeRequestHttpSyncer.this.addNextSyncToWorkQueue();
                        }
                    }
                }

                private void handleFailure(Throwable t) {
                    String logMsg = StringUtils.nonStrictFormat("failed to get sync response from [%s]. Return code [%s], Reason: [%s]", ChangeRequestHttpSyncer.this.logIdentity, responseHandler.getStatus(), responseHandler.getDescription());
                    if (ChangeRequestHttpSyncer.this.incrementFailedAttemptAndCheckUnstabilityTimeout()) {
                        log.error(t, logMsg, new Object[0]);
                    } else {
                        log.info("Temporary Failure. %s", logMsg);
                        log.debug(t, logMsg, new Object[0]);
                    }
                }
            }, this.executor);
        }
        catch (Throwable th) {
            try {
                String logMsg = StringUtils.nonStrictFormat("Fatal error while fetching segment list from [%s].", this.logIdentity);
                if (this.incrementFailedAttemptAndCheckUnstabilityTimeout()) {
                    log.makeAlert(th, logMsg, new Object[0]).emit();
                } else {
                    log.info("Temporary Failure. %s", logMsg);
                    log.debug(th, logMsg, new Object[0]);
                }
            }
            finally {
                this.addNextSyncToWorkQueue();
            }
        }
    }

    private String getRequestString() {
        String req = this.counter != null ? StringUtils.format("%s?counter=%s&hash=%s&timeout=%s", this.baseRequestPath, this.counter.getCounter(), this.counter.getHash(), this.serverTimeoutMS) : StringUtils.format("%s?counter=-1&timeout=%s", this.baseRequestPath, this.serverTimeoutMS);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNextSyncToWorkQueue() {
        LifecycleLock lifecycleLock = this.startStopLock;
        synchronized (lifecycleLock) {
            if (!this.startStopLock.awaitStarted(1L, TimeUnit.MILLISECONDS)) {
                log.info("Not scheduling sync for server[%s]. Instance stopped.", this.logIdentity);
                return;
            }
            try {
                if (this.consecutiveFailedAttemptCount > 0) {
                    long sleepMillis = Math.min(MAX_RETRY_BACKOFF, RetryUtils.nextRetrySleepMillis(this.consecutiveFailedAttemptCount));
                    log.info("Scheduling next syncup in [%d] millis for server[%s].", sleepMillis, this.logIdentity);
                    this.executor.schedule(this::sync, sleepMillis, TimeUnit.MILLISECONDS);
                } else {
                    this.executor.execute(this::sync);
                }
            }
            catch (Throwable th) {
                if (this.executor.isShutdown()) {
                    log.warn(th, "Couldn't schedule next sync. [%s] is not being synced any more, probably because executor is stopped.", this.logIdentity);
                }
                log.makeAlert(th, "WTF! Couldn't schedule next sync. [%s] is not being synced any more, restarting Druid process on that server might fix the issue.", this.logIdentity).emit();
            }
        }
    }

    private boolean incrementFailedAttemptAndCheckUnstabilityTimeout() {
        if (this.consecutiveFailedAttemptCount > 0 && System.currentTimeMillis() - this.unstableStartTime > this.serverUnstabilityTimeout) {
            return true;
        }
        if (this.consecutiveFailedAttemptCount++ == 0) {
            this.unstableStartTime = System.currentTimeMillis();
        }
        return false;
    }

    public static interface Listener<T> {
        public void fullSync(List<T> var1);

        public void deltaSync(List<T> var1);
    }
}

