/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryContexts;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.server.initialization.ServerConfig;

public class SetAndVerifyContextQueryRunner<T>
implements QueryRunner<T> {
    private final ServerConfig serverConfig;
    private final QueryRunner<T> baseRunner;
    private final long startTimeMillis;

    public SetAndVerifyContextQueryRunner(ServerConfig serverConfig, QueryRunner<T> baseRunner) {
        this.serverConfig = serverConfig;
        this.baseRunner = baseRunner;
        this.startTimeMillis = System.currentTimeMillis();
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        return this.baseRunner.run(QueryPlus.wrap(this.withTimeoutAndMaxScatterGatherBytes(queryPlus.getQuery(), this.serverConfig)), responseContext);
    }

    public Query<T> withTimeoutAndMaxScatterGatherBytes(Query<T> query, ServerConfig serverConfig) {
        Query<T> newQuery = QueryContexts.verifyMaxQueryTimeout(QueryContexts.withMaxScatterGatherBytes(QueryContexts.withDefaultTimeout(query, Math.min(serverConfig.getDefaultQueryTimeout(), serverConfig.getMaxQueryTimeout())), serverConfig.getMaxScatterGatherBytes()), serverConfig.getMaxQueryTimeout());
        return newQuery.withOverriddenContext(ImmutableMap.of("queryFailTime", this.startTimeMillis + QueryContexts.getTimeout(newQuery)));
    }
}

