/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.writeout;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.org.apache.druid.io.Channels;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.segment.writeout.WriteOutBytes;

final class FileWriteOutBytes
extends WriteOutBytes {
    private final File file;
    private final FileChannel ch;
    private final ByteBuffer buffer = ByteBuffer.allocate(4096);

    FileWriteOutBytes(File file, FileChannel ch) {
        this.file = file;
        this.ch = ch;
    }

    private void flushIfNeeded(int bytesNeeded) throws IOException {
        if (this.buffer.remaining() < bytesNeeded) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flip();
        Channels.writeFully(this.ch, this.buffer);
        this.buffer.clear();
    }

    @Override
    public void write(int b) throws IOException {
        this.flushIfNeeded(1);
        this.buffer.put((byte)b);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.flushIfNeeded(32);
        this.buffer.putInt(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        this.flushIfNeeded(len);
        while (src.remaining() > this.buffer.capacity()) {
            int srcLimit = src.limit();
            try {
                src.limit(src.position() + this.buffer.capacity());
                this.buffer.put(src);
                this.flush();
            }
            finally {
                src.limit(srcLimit);
            }
        }
        this.buffer.put(src);
        return len;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap(b, off, len));
    }

    @Override
    public long size() throws IOException {
        this.flush();
        return this.ch.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel) throws IOException {
        this.flush();
        this.ch.position(0L);
        try {
            ByteStreams.copy(this.ch, channel);
        }
        finally {
            this.ch.position(this.ch.size());
        }
    }

    @Override
    public void readFully(long pos, ByteBuffer buffer) throws IOException {
        this.flush();
        if (pos < 0L || pos > this.ch.size()) {
            throw new IAE("pos %d out of range [%d, %d]", pos, 0, this.ch.size());
        }
        this.ch.read(buffer, pos);
        if (buffer.remaining() > 0) {
            throw new BufferUnderflowException();
        }
    }

    @Override
    public InputStream asInputStream() throws IOException {
        this.flush();
        return new FileInputStream(this.file);
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }
}

