/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.plumber;

import java.io.IOException;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.org.apache.druid.data.input.Committer;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.Plumber;

public class Plumbers {
    private static final Logger log = new Logger(Plumbers.class);

    private Plumbers() {
    }

    public static void addNextRow(Supplier<Committer> committerSupplier, Firehose firehose, Plumber plumber, boolean reportParseExceptions, FireDepartmentMetrics metrics) throws IOException {
        IncrementalIndexAddResult addResult;
        InputRow inputRow;
        try {
            inputRow = firehose.nextRow();
        }
        catch (ParseException e) {
            if (reportParseExceptions) {
                throw e;
            }
            log.debug(e, "Discarded row due to exception, considering unparseable.", new Object[0]);
            metrics.incrementUnparseable();
            return;
        }
        if (inputRow == null) {
            log.debug("Discarded null row, considering thrownAway.", new Object[0]);
            metrics.incrementThrownAway();
            return;
        }
        try {
            addResult = plumber.add(inputRow, committerSupplier);
        }
        catch (IndexSizeExceededException e) {
            throw new ISE(e, "WTF?! Index size exceeded, this shouldn't happen. Bad Plumber!", new Object[0]);
        }
        if (addResult.getRowCount() == -1) {
            metrics.incrementThrownAway();
            log.debug("Discarded row[%s], considering thrownAway due to %s.", inputRow, addResult.getReasonOfNotAdded());
            return;
        }
        if (addResult.getRowCount() == -2) {
            metrics.incrementDedup();
            log.debug("Discarded row[%s], considering duplication.", inputRow);
            return;
        }
        metrics.incrementProcessed();
    }
}

