/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.firehose;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Smile;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.hive.druid.org.apache.druid.metadata.SQLFirehoseDatabaseConnector;
import org.apache.hive.druid.org.apache.druid.segment.realtime.firehose.PrefetchSqlFirehoseFactory;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.exceptions.ResultSetException;
import org.skife.jdbi.v2.exceptions.StatementException;

public class SqlFirehoseFactory
extends PrefetchSqlFirehoseFactory<String> {
    @JsonProperty
    private final List<String> sqls;
    @Nullable
    @JsonProperty
    private final MetadataStorageConnectorConfig connectorConfig;
    private final ObjectMapper objectMapper;
    @JsonProperty
    private final SQLFirehoseDatabaseConnector sqlFirehoseDatabaseConnector;
    private final boolean foldCase;

    @JsonCreator
    public SqlFirehoseFactory(@JsonProperty(value="sqls") List<String> sqls, @JsonProperty(value="maxCacheCapacityBytes") Long maxCacheCapacityBytes, @JsonProperty(value="maxFetchCapacityBytes") Long maxFetchCapacityBytes, @JsonProperty(value="prefetchTriggerBytes") Long prefetchTriggerBytes, @JsonProperty(value="fetchTimeout") Long fetchTimeout, @JsonProperty(value="foldCase") boolean foldCase, @JsonProperty(value="database") SQLFirehoseDatabaseConnector sqlFirehoseDatabaseConnector, @JacksonInject @Smile ObjectMapper objectMapper) {
        super(maxCacheCapacityBytes, maxFetchCapacityBytes, prefetchTriggerBytes, fetchTimeout, objectMapper);
        Preconditions.checkArgument(sqls.size() > 0, "No SQL queries provided");
        this.sqls = sqls;
        this.objectMapper = objectMapper;
        this.sqlFirehoseDatabaseConnector = sqlFirehoseDatabaseConnector;
        this.foldCase = foldCase;
        this.connectorConfig = null;
    }

    @Override
    protected InputStream openObjectStream(String sql, File fileName) throws IOException {
        Preconditions.checkNotNull(this.sqlFirehoseDatabaseConnector, "SQL Metadata Connector not configured!");
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            JsonGenerator jg = this.objectMapper.getFactory().createGenerator(fos);
            this.sqlFirehoseDatabaseConnector.retryWithHandle(handle -> {
                Iterator resultIterator = handle.createQuery(sql).map((index, r, ctx) -> {
                    ResultSetMetaData resultMetadata;
                    HashMap resultRow = this.foldCase ? new CaseFoldedMap() : new HashMap();
                    try {
                        resultMetadata = r.getMetaData();
                    }
                    catch (SQLException e) {
                        throw new ResultSetException("Unable to obtain metadata from result set", e, ctx);
                    }
                    try {
                        for (int i = 1; i <= resultMetadata.getColumnCount(); ++i) {
                            String key = resultMetadata.getColumnName(i);
                            String alias = resultMetadata.getColumnLabel(i);
                            Object value = r.getObject(i);
                            resultRow.put(alias != null ? alias : key, value);
                        }
                    }
                    catch (SQLException e) {
                        throw new ResultSetException("Unable to access specific metadata from result set metadata", e, ctx);
                    }
                    return resultRow;
                }).iterator();
                jg.writeStartArray();
                while (resultIterator.hasNext()) {
                    jg.writeObject(resultIterator.next());
                }
                jg.writeEndArray();
                jg.close();
                return null;
            }, exception -> {
                boolean isStatementException = exception instanceof StatementException || exception instanceof CallbackFailedException && exception.getCause() instanceof StatementException;
                return this.sqlFirehoseDatabaseConnector.isTransientException((Throwable)exception) && !isStatementException;
            });
        }
        return new FileInputStream(fileName);
    }

    @Override
    protected Collection<String> initObjects() {
        return this.sqls;
    }

    private static class CaseFoldedMap
    extends HashMap<String, Object> {
        public static final long serialVersionUID = 1L;

        private CaseFoldedMap() {
        }

        @Override
        public Object get(Object obj) {
            return super.get(StringUtils.toLowerCase((String)obj));
        }

        @Override
        public Object put(String key, Object value) {
            return super.put(StringUtils.toLowerCase(key), value);
        }

        @Override
        public boolean containsKey(Object obj) {
            return super.containsKey(StringUtils.toLowerCase((String)obj));
        }
    }
}

