/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.druid.org.apache.druid.data.input.Committer;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.ListenableFutures;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.hive.druid.org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorDriverAddResult;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorDriverMetadata;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorDriverSegmentLockHelper;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.BaseAppenderatorDriver;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentWithState;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.SegmentHandoffNotifier;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;

public class StreamAppenderatorDriver
extends BaseAppenderatorDriver {
    private static final Logger log = new Logger(StreamAppenderatorDriver.class);
    private final SegmentHandoffNotifier handoffNotifier;
    private final FireDepartmentMetrics metrics;
    private final ObjectMapper objectMapper;

    public StreamAppenderatorDriver(Appenderator appenderator, SegmentAllocator segmentAllocator, SegmentHandoffNotifierFactory handoffNotifierFactory, UsedSegmentChecker usedSegmentChecker, DataSegmentKiller dataSegmentKiller, ObjectMapper objectMapper, FireDepartmentMetrics metrics) {
        super(appenderator, segmentAllocator, usedSegmentChecker, dataSegmentKiller);
        this.handoffNotifier = Preconditions.checkNotNull(handoffNotifierFactory, "handoffNotifierFactory").createSegmentHandoffNotifier(appenderator.getDataSource());
        this.metrics = Preconditions.checkNotNull(metrics, "metrics");
        this.objectMapper = Preconditions.checkNotNull(objectMapper, "objectMapper");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object startJob(AppenderatorDriverSegmentLockHelper lockHelper) {
        this.handoffNotifier.start();
        AppenderatorDriverMetadata metadata = this.objectMapper.convertValue(this.appenderator.startJob(), AppenderatorDriverMetadata.class);
        if (metadata != null) {
            Map map = this.segments;
            synchronized (map) {
                Map<String, String> lastSegmentIds = metadata.getLastSegmentIds();
                Preconditions.checkState(metadata.getSegments().keySet().equals(lastSegmentIds.keySet()), "Sequences for segment states and last segment IDs are not same");
                TreeMap<String, SegmentsForSequenceBuilder> builders = new TreeMap<String, SegmentsForSequenceBuilder>();
                for (Map.Entry<String, List<SegmentWithState>> entry : metadata.getSegments().entrySet()) {
                    String sequenceName = entry.getKey();
                    SegmentsForSequenceBuilder builder2 = new SegmentsForSequenceBuilder(lastSegmentIds.get(sequenceName));
                    builders.put(sequenceName, builder2);
                    entry.getValue().forEach(builder2::add);
                    if (lockHelper == null) continue;
                    for (SegmentWithState segmentWithState : entry.getValue()) {
                        if (segmentWithState.getState() == SegmentWithState.SegmentState.PUSHED_AND_DROPPED || lockHelper.lock(segmentWithState.getSegmentIdentifier())) continue;
                        throw new ISE("Failed to lock segment[%s]", segmentWithState.getSegmentIdentifier());
                    }
                }
                builders.forEach((sequence, builder) -> this.segments.put(sequence, builder.build()));
            }
            return metadata.getCallerMetadata();
        }
        return null;
    }

    public AppenderatorDriverAddResult add(InputRow row, String sequenceName, Supplier<Committer> committerSupplier) throws IOException {
        return this.append(row, sequenceName, committerSupplier, false, true);
    }

    public AppenderatorDriverAddResult add(InputRow row, String sequenceName, Supplier<Committer> committerSupplier, boolean skipSegmentLineageCheck, boolean allowIncrementalPersists) throws IOException {
        return this.append(row, sequenceName, committerSupplier, skipSegmentLineageCheck, allowIncrementalPersists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveSegmentOut(String sequenceName, List<SegmentIdWithShardSpec> identifiers) {
        Map map = this.segments;
        synchronized (map) {
            BaseAppenderatorDriver.SegmentsForSequence activeSegmentsForSequence = (BaseAppenderatorDriver.SegmentsForSequence)this.segments.get(sequenceName);
            if (activeSegmentsForSequence == null) {
                throw new ISE("WTF?! Asked to remove segments for sequenceName[%s] which doesn't exist...", sequenceName);
            }
            for (SegmentIdWithShardSpec identifier : identifiers) {
                log.info("Moving segment[%s] out of active list.", identifier);
                long key = identifier.getInterval().getStartMillis();
                BaseAppenderatorDriver.SegmentsOfInterval segmentsOfInterval = activeSegmentsForSequence.get(key);
                if (segmentsOfInterval == null || segmentsOfInterval.getAppendingSegment() == null || !segmentsOfInterval.getAppendingSegment().getSegmentIdentifier().equals(identifier)) {
                    throw new ISE("WTF?! Asked to remove segment[%s] that didn't exist...", identifier);
                }
                segmentsOfInterval.finishAppendingToCurrentActiveSegment(SegmentWithState::finishAppending);
            }
        }
    }

    public Object persist(Committer committer) throws InterruptedException {
        try {
            log.debug("Persisting pending data.", new Object[0]);
            long start = System.currentTimeMillis();
            Object commitMetadata = this.appenderator.persistAll(this.wrapCommitter(committer)).get();
            log.debug("Persisted pending data in %,dms.", System.currentTimeMillis() - start);
            return commitMetadata;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ListenableFuture<Object> persistAsync(Committer committer) {
        return this.appenderator.persistAll(this.wrapCommitter(committer));
    }

    public ListenableFuture<SegmentsAndMetadata> publish(TransactionalSegmentPublisher publisher, Committer committer, Collection<String> sequenceNames) {
        List<SegmentIdWithShardSpec> theSegments = this.getSegmentWithStates(sequenceNames).map(SegmentWithState::getSegmentIdentifier).collect(Collectors.toList());
        ListenableFuture publishFuture = ListenableFutures.transformAsync(this.pushInBackground(this.wrapCommitter(committer), theSegments, true), sam -> this.publishInBackground(null, (SegmentsAndMetadata)sam, publisher));
        return Futures.transform(publishFuture, sam -> {
            Map map = this.segments;
            synchronized (map) {
                sequenceNames.forEach(this.segments::remove);
            }
            return sam;
        });
    }

    public ListenableFuture<SegmentsAndMetadata> registerHandoff(final SegmentsAndMetadata segmentsAndMetadata) {
        if (segmentsAndMetadata == null) {
            return Futures.immediateFuture(null);
        }
        List waitingSegmentIdList = segmentsAndMetadata.getSegments().stream().map(SegmentIdWithShardSpec::fromDataSegment).collect(Collectors.toList());
        final Object metadata = Preconditions.checkNotNull(segmentsAndMetadata.getCommitMetadata(), "commitMetadata");
        if (waitingSegmentIdList.isEmpty()) {
            return Futures.immediateFuture(new SegmentsAndMetadata(segmentsAndMetadata.getSegments(), ((AppenderatorDriverMetadata)metadata).getCallerMetadata()));
        }
        log.debug("Register handoff of segments: [%s]", waitingSegmentIdList);
        final SettableFuture<SegmentsAndMetadata> resultFuture = SettableFuture.create();
        final AtomicInteger numRemainingHandoffSegments = new AtomicInteger(waitingSegmentIdList.size());
        for (final SegmentIdWithShardSpec segmentIdentifier : waitingSegmentIdList) {
            this.handoffNotifier.registerSegmentHandoffCallback(new SegmentDescriptor(segmentIdentifier.getInterval(), segmentIdentifier.getVersion(), segmentIdentifier.getShardSpec().getPartitionNum()), Execs.directExecutor(), () -> {
                log.debug("Segment[%s] successfully handed off, dropping.", segmentIdentifier);
                this.metrics.incrementHandOffCount();
                ListenableFuture<?> dropFuture = this.appenderator.drop(segmentIdentifier);
                Futures.addCallback(dropFuture, new FutureCallback<Object>(){

                    @Override
                    public void onSuccess(Object result) {
                        if (numRemainingHandoffSegments.decrementAndGet() == 0) {
                            log.debug("Successfully handed off [%d] segments.", segmentsAndMetadata.getSegments().size());
                            resultFuture.set(new SegmentsAndMetadata(segmentsAndMetadata.getSegments(), ((AppenderatorDriverMetadata)metadata).getCallerMetadata()));
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        log.warn(e, "Failed to drop segment[%s]?!", segmentIdentifier);
                        numRemainingHandoffSegments.decrementAndGet();
                        resultFuture.setException(e);
                    }
                });
            });
        }
        return resultFuture;
    }

    public ListenableFuture<SegmentsAndMetadata> publishAndRegisterHandoff(TransactionalSegmentPublisher publisher, Committer committer, Collection<String> sequenceNames) {
        return ListenableFutures.transformAsync(this.publish(publisher, committer, sequenceNames), this::registerHandoff);
    }

    @Override
    public void close() {
        super.close();
        this.handoffNotifier.close();
    }

    private static class SegmentsForSequenceBuilder {
        private final NavigableMap<SegmentIdWithShardSpec, Pair<SegmentWithState, List<SegmentWithState>>> intervalToSegments = new TreeMap<SegmentIdWithShardSpec, Pair<SegmentWithState, List<SegmentWithState>>>(Comparator.comparing(SegmentIdWithShardSpec::getInterval, Comparators.intervalsByStartThenEnd()));
        private final String lastSegmentId;

        SegmentsForSequenceBuilder(String lastSegmentId) {
            this.lastSegmentId = lastSegmentId;
        }

        void add(SegmentWithState segmentWithState) {
            ArrayList<SegmentWithState> appendFinishedSegments;
            SegmentIdWithShardSpec identifier = segmentWithState.getSegmentIdentifier();
            Pair pair = (Pair)this.intervalToSegments.get(identifier);
            List<SegmentWithState> list = appendFinishedSegments = pair == null || pair.rhs == null ? new ArrayList<SegmentWithState>() : (List)pair.rhs;
            if (segmentWithState.getState() == SegmentWithState.SegmentState.APPENDING) {
                if (pair != null && pair.lhs != null) {
                    throw new ISE("WTF?! there was already an appendingSegment[%s] before adding an appendingSegment[%s]", pair.lhs, segmentWithState);
                }
                this.intervalToSegments.put(identifier, Pair.of(segmentWithState, appendFinishedSegments));
            } else {
                SegmentWithState appendingSegment = pair == null ? null : (SegmentWithState)pair.lhs;
                appendFinishedSegments.add(segmentWithState);
                this.intervalToSegments.put(identifier, Pair.of(appendingSegment, appendFinishedSegments));
            }
        }

        BaseAppenderatorDriver.SegmentsForSequence build() {
            TreeMap<Long, BaseAppenderatorDriver.SegmentsOfInterval> map = new TreeMap<Long, BaseAppenderatorDriver.SegmentsOfInterval>();
            for (Map.Entry entry : this.intervalToSegments.entrySet()) {
                map.put(((SegmentIdWithShardSpec)entry.getKey()).getInterval().getStartMillis(), new BaseAppenderatorDriver.SegmentsOfInterval(((SegmentIdWithShardSpec)entry.getKey()).getInterval(), (SegmentWithState)((Pair)entry.getValue()).lhs, (List)((Pair)entry.getValue()).rhs));
            }
            return new BaseAppenderatorDriver.SegmentsForSequence(map, this.lastSegmentId);
        }
    }
}

