/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Preconditions;

public class FireDepartmentMetrics {
    private final AtomicLong processedCount = new AtomicLong(0L);
    private final AtomicLong processedWithErrorsCount = new AtomicLong(0L);
    private final AtomicLong thrownAwayCount = new AtomicLong(0L);
    private final AtomicLong unparseableCount = new AtomicLong(0L);
    private final AtomicLong dedupCount = new AtomicLong(0L);
    private final AtomicLong rowOutputCount = new AtomicLong(0L);
    private final AtomicLong numPersists = new AtomicLong(0L);
    private final AtomicLong persistTimeMillis = new AtomicLong(0L);
    private final AtomicLong persistBackPressureMillis = new AtomicLong(0L);
    private final AtomicLong failedPersists = new AtomicLong(0L);
    private final AtomicLong failedHandoffs = new AtomicLong(0L);
    private final AtomicLong mergeTimeMillis = new AtomicLong(0L);
    private final AtomicLong mergeCpuTime = new AtomicLong(0L);
    private final AtomicLong persistCpuTime = new AtomicLong(0L);
    private final AtomicLong handOffCount = new AtomicLong(0L);
    private final AtomicLong sinkCount = new AtomicLong(0L);
    private final AtomicLong messageMaxTimestamp = new AtomicLong(0L);
    private final AtomicLong messageGap = new AtomicLong(0L);

    public void incrementProcessed() {
        this.processedCount.incrementAndGet();
    }

    public void incrementProcessedWithErrors() {
        this.processedWithErrorsCount.incrementAndGet();
    }

    public void incrementThrownAway() {
        this.thrownAwayCount.incrementAndGet();
    }

    public void incrementDedup() {
        this.dedupCount.incrementAndGet();
    }

    public void incrementUnparseable() {
        this.unparseableCount.incrementAndGet();
    }

    public void incrementRowOutputCount(long numRows) {
        this.rowOutputCount.addAndGet(numRows);
    }

    public void incrementNumPersists() {
        this.numPersists.incrementAndGet();
    }

    public void incrementPersistTimeMillis(long millis) {
        this.persistTimeMillis.addAndGet(millis);
    }

    public void incrementPersistBackPressureMillis(long millis) {
        this.persistBackPressureMillis.addAndGet(millis);
    }

    public void incrementFailedPersists() {
        this.failedPersists.incrementAndGet();
    }

    public void incrementFailedHandoffs() {
        this.failedHandoffs.incrementAndGet();
    }

    public void incrementMergeTimeMillis(long millis) {
        this.mergeTimeMillis.addAndGet(millis);
    }

    public void incrementMergeCpuTime(long mergeTime) {
        this.mergeCpuTime.addAndGet(mergeTime);
    }

    public void incrementPersistCpuTime(long persistTime) {
        this.persistCpuTime.addAndGet(persistTime);
    }

    public void incrementHandOffCount() {
        this.handOffCount.incrementAndGet();
    }

    public void setSinkCount(long sinkCount) {
        this.sinkCount.set(sinkCount);
    }

    public void reportMessageMaxTimestamp(long messageMaxTimestamp) {
        this.messageMaxTimestamp.set(Math.max(messageMaxTimestamp, this.messageMaxTimestamp.get()));
    }

    public long processed() {
        return this.processedCount.get();
    }

    public long processedWithErrors() {
        return this.processedWithErrorsCount.get();
    }

    public long thrownAway() {
        return this.thrownAwayCount.get();
    }

    public long unparseable() {
        return this.unparseableCount.get();
    }

    public long dedup() {
        return this.dedupCount.get();
    }

    public long rowOutput() {
        return this.rowOutputCount.get();
    }

    public long numPersists() {
        return this.numPersists.get();
    }

    public long persistTimeMillis() {
        return this.persistTimeMillis.get();
    }

    public long persistBackPressureMillis() {
        return this.persistBackPressureMillis.get();
    }

    public long failedPersists() {
        return this.failedPersists.get();
    }

    public long failedHandoffs() {
        return this.failedHandoffs.get();
    }

    public long mergeTimeMillis() {
        return this.mergeTimeMillis.get();
    }

    public long mergeCpuTime() {
        return this.mergeCpuTime.get();
    }

    public long persistCpuTime() {
        return this.persistCpuTime.get();
    }

    public long handOffCount() {
        return this.handOffCount.get();
    }

    public long sinkCount() {
        return this.sinkCount.get();
    }

    public long messageMaxTimestamp() {
        return this.messageMaxTimestamp.get();
    }

    public long messageGap() {
        return this.messageGap.get();
    }

    public FireDepartmentMetrics snapshot() {
        FireDepartmentMetrics retVal = new FireDepartmentMetrics();
        retVal.processedCount.set(this.processedCount.get());
        retVal.processedWithErrorsCount.set(this.processedWithErrorsCount.get());
        retVal.thrownAwayCount.set(this.thrownAwayCount.get());
        retVal.unparseableCount.set(this.unparseableCount.get());
        retVal.dedupCount.set(this.dedupCount.get());
        retVal.rowOutputCount.set(this.rowOutputCount.get());
        retVal.numPersists.set(this.numPersists.get());
        retVal.persistTimeMillis.set(this.persistTimeMillis.get());
        retVal.persistBackPressureMillis.set(this.persistBackPressureMillis.get());
        retVal.failedPersists.set(this.failedPersists.get());
        retVal.failedHandoffs.set(this.failedHandoffs.get());
        retVal.mergeTimeMillis.set(this.mergeTimeMillis.get());
        retVal.mergeCpuTime.set(this.mergeCpuTime.get());
        retVal.persistCpuTime.set(this.persistCpuTime.get());
        retVal.handOffCount.set(this.handOffCount.get());
        retVal.sinkCount.set(this.sinkCount.get());
        retVal.messageMaxTimestamp.set(this.messageMaxTimestamp.get());
        retVal.messageGap.set(System.currentTimeMillis() - this.messageMaxTimestamp.get());
        return retVal;
    }

    public FireDepartmentMetrics merge(FireDepartmentMetrics other) {
        Preconditions.checkNotNull(other, "Cannot merge a null FireDepartmentMetrics");
        FireDepartmentMetrics otherSnapshot = other.snapshot();
        this.processedCount.addAndGet(otherSnapshot.processed());
        this.processedWithErrorsCount.addAndGet(otherSnapshot.processedWithErrors());
        this.thrownAwayCount.addAndGet(otherSnapshot.thrownAway());
        this.rowOutputCount.addAndGet(otherSnapshot.rowOutput());
        this.unparseableCount.addAndGet(otherSnapshot.unparseable());
        this.dedupCount.addAndGet(otherSnapshot.dedup());
        this.numPersists.addAndGet(otherSnapshot.numPersists());
        this.persistTimeMillis.addAndGet(otherSnapshot.persistTimeMillis());
        this.persistBackPressureMillis.addAndGet(otherSnapshot.persistBackPressureMillis());
        this.failedPersists.addAndGet(otherSnapshot.failedPersists());
        this.failedHandoffs.addAndGet(otherSnapshot.failedHandoffs());
        this.mergeTimeMillis.addAndGet(otherSnapshot.mergeTimeMillis());
        this.mergeCpuTime.addAndGet(otherSnapshot.mergeCpuTime());
        this.persistCpuTime.addAndGet(otherSnapshot.persistCpuTime());
        this.handOffCount.addAndGet(otherSnapshot.handOffCount());
        this.sinkCount.addAndGet(otherSnapshot.sinkCount());
        this.messageMaxTimestamp.set(Math.max(this.messageMaxTimestamp(), otherSnapshot.messageMaxTimestamp()));
        this.messageGap.set(Math.max(this.messageGap(), otherSnapshot.messageGap()));
        return this;
    }
}

