/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;

public class StorageLocationConfig {
    private final File path;
    private final long maxSize;
    @Nullable
    private final Double freeSpacePercent;

    @JsonCreator
    public StorageLocationConfig(@JsonProperty(value="path") File path, @JsonProperty(value="maxSize") @Nullable Long maxSize, @JsonProperty(value="freeSpacePercent") @Nullable Double freeSpacePercent) {
        this.path = Preconditions.checkNotNull(path, "path");
        this.maxSize = maxSize == null ? Long.MAX_VALUE : maxSize;
        this.freeSpacePercent = freeSpacePercent;
        Preconditions.checkArgument(this.maxSize > 0L, "maxSize[%s] should be positive", this.maxSize);
        Preconditions.checkArgument(this.freeSpacePercent == null || this.freeSpacePercent >= 0.0, "freeSpacePercent[%s] should be 0 or a positive double", this.freeSpacePercent);
    }

    @JsonProperty
    public File getPath() {
        return this.path;
    }

    @JsonProperty
    public long getMaxSize() {
        return this.maxSize;
    }

    @JsonProperty
    @Nullable
    public Double getFreeSpacePercent() {
        return this.freeSpacePercent;
    }

    public String toString() {
        return "StorageLocationConfig{path=" + this.path + ", maxSize=" + this.maxSize + ", freeSpacePercent=" + this.freeSpacePercent + '}';
    }
}

