/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

public class StorageLocation {
    private static final Logger log = new Logger(StorageLocation.class);
    private final File path;
    private final long maxSizeBytes;
    private final long freeSpaceToKeep;
    @GuardedBy(value="this")
    private final Set<File> files = new HashSet<File>();
    @GuardedBy(value="this")
    private long currSizeBytes = 0L;

    public StorageLocation(File path, long maxSizeBytes, @Nullable Double freeSpacePercent) {
        this.path = path;
        this.maxSizeBytes = maxSizeBytes;
        if (freeSpacePercent != null) {
            long totalSpaceInPartition = path.getTotalSpace();
            this.freeSpaceToKeep = (long)(freeSpacePercent * (double)totalSpaceInPartition / 100.0);
            log.info("SegmentLocation[%s] will try and maintain [%d:%d] free space while loading segments.", path, this.freeSpaceToKeep, totalSpaceInPartition);
        } else {
            this.freeSpaceToKeep = 0L;
        }
    }

    public File getPath() {
        return this.path;
    }

    public synchronized void removeFile(File file) {
        if (this.files.remove(file)) {
            this.currSizeBytes -= FileUtils.sizeOf((File)file);
        } else {
            log.warn("File[%s] is not found under this location[%s]", file, this.path);
        }
    }

    public synchronized void removeSegmentDir(File segmentDir, DataSegment segment) {
        if (this.files.remove(segmentDir)) {
            this.currSizeBytes -= segment.getSize();
        } else {
            log.warn("SegmentDir[%s] is not found under this location[%s]", segmentDir, this.path);
        }
    }

    @Nullable
    public synchronized File reserve(String segmentDir, DataSegment segment) {
        return this.reserve(segmentDir, segment.getId().toString(), segment.getSize());
    }

    @Nullable
    public synchronized File reserve(String segmentFilePathToAdd, String segmentId, long segmentSize) {
        File segmentFileToAdd = new File(this.path, segmentFilePathToAdd);
        if (this.files.contains(segmentFileToAdd)) {
            return null;
        }
        if (this.canHandle(segmentId, segmentSize)) {
            this.files.add(segmentFileToAdd);
            this.currSizeBytes += segmentSize;
            return segmentFileToAdd;
        }
        return null;
    }

    @VisibleForTesting
    @GuardedBy(value="this")
    boolean canHandle(String segmentId, long segmentSize) {
        long currFreeSpace;
        if (this.availableSizeBytes() < segmentSize) {
            log.warn("Segment[%s:%,d] too large for storage[%s:%,d]. Check your druid.segmentCache.locations maxSize param", segmentId, segmentSize, this.getPath(), this.availableSizeBytes());
            return false;
        }
        if (this.freeSpaceToKeep > 0L && this.freeSpaceToKeep + segmentSize > (currFreeSpace = this.path.getFreeSpace())) {
            log.warn("Segment[%s:%,d] too large for storage[%s:%,d] to maintain suggested freeSpace[%d], current freeSpace is [%d].", segmentId, segmentSize, this.getPath(), this.availableSizeBytes(), this.freeSpaceToKeep, currFreeSpace);
            return false;
        }
        return true;
    }

    public synchronized long availableSizeBytes() {
        return this.maxSizeBytes - this.currSizeBytes;
    }

    public synchronized long currSizeBytes() {
        return this.currSizeBytes;
    }
}

