/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

public interface DataSegmentPusher {
    public static final Joiner JOINER = Joiner.on("/").skipNulls();

    @Deprecated
    public String getPathForHadoop(String var1);

    public String getPathForHadoop();

    public DataSegment push(File var1, DataSegment var2, boolean var3) throws IOException;

    public Map<String, Object> makeLoadSpec(URI var1);

    @Deprecated
    default public String getStorageDir(DataSegment dataSegment) {
        return this.getStorageDir(dataSegment, false);
    }

    default public String getStorageDir(DataSegment dataSegment, boolean useUniquePath) {
        return DataSegmentPusher.getDefaultStorageDir(dataSegment, useUniquePath);
    }

    default public String makeIndexPathName(DataSegment dataSegment, String indexName) {
        return StringUtils.format("./%s/%s", this.getStorageDir(dataSegment, false), indexName);
    }

    default public List<String> getAllowedPropertyPrefixesForHadoop() {
        return Collections.emptyList();
    }

    public static String getDefaultStorageDir(DataSegment segment, boolean useUniquePath) {
        return JOINER.join(segment.getDataSource(), StringUtils.format("%s_%s", segment.getInterval().getStart(), segment.getInterval().getEnd()), segment.getVersion(), segment.getShardSpec().getPartitionNum(), useUniquePath ? DataSegmentPusher.generateUniquePath() : null);
    }

    public static String getDefaultStorageDirWithExistingUniquePath(DataSegment segment, String uniquePath) {
        return JOINER.join(segment.getDataSource(), StringUtils.format("%s_%s", segment.getInterval().getStart(), segment.getInterval().getEnd()), segment.getVersion(), segment.getShardSpec().getPartitionNum(), uniquePath);
    }

    public static String generateUniquePath() {
        return UUID.randomUUID().toString();
    }
}

