/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.indexing;

import java.io.File;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.indexing.TuningConfig;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.IntervalStartVersioningPolicy;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.RejectionPolicyFactory;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.ServerTimeRejectionPolicyFactory;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.VersioningPolicy;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Period;

public class RealtimeTuningConfig
implements TuningConfig,
AppenderatorConfig {
    private static final int DEFAULT_MAX_ROWS_IN_MEMORY = 1000000;
    private static final Period DEFAULT_INTERMEDIATE_PERSIST_PERIOD = new Period((Object)"PT10M");
    private static final Period DEFAULT_WINDOW_PERIOD = new Period((Object)"PT10M");
    private static final VersioningPolicy DEFAULT_VERSIONING_POLICY = new IntervalStartVersioningPolicy();
    private static final RejectionPolicyFactory DEFAULT_REJECTION_POLICY_FACTORY = new ServerTimeRejectionPolicyFactory();
    private static final int DEFAULT_MAX_PENDING_PERSISTS = 0;
    private static final ShardSpec DEFAULT_SHARD_SPEC = new NumberedShardSpec(0, 1);
    private static final IndexSpec DEFAULT_INDEX_SPEC = new IndexSpec();
    private static final Boolean DEFAULT_REPORT_PARSE_EXCEPTIONS = Boolean.FALSE;
    private static final long DEFAULT_HANDOFF_CONDITION_TIMEOUT = 0L;
    private static final long DEFAULT_ALERT_TIMEOUT = 0L;
    private static final String DEFAULT_DEDUP_COLUMN = null;
    private final int maxRowsInMemory;
    private final long maxBytesInMemory;
    private final Period intermediatePersistPeriod;
    private final Period windowPeriod;
    private final File basePersistDirectory;
    private final VersioningPolicy versioningPolicy;
    private final RejectionPolicyFactory rejectionPolicyFactory;
    private final int maxPendingPersists;
    private final ShardSpec shardSpec;
    private final IndexSpec indexSpec;
    private final IndexSpec indexSpecForIntermediatePersists;
    private final int persistThreadPriority;
    private final int mergeThreadPriority;
    private final boolean reportParseExceptions;
    private final long handoffConditionTimeout;
    private final long alertTimeout;
    @Nullable
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
    @Nullable
    private final String dedupColumn;

    private static File createNewBasePersistDirectory() {
        return FileUtils.createTempDir("druid-realtime-persist");
    }

    public static RealtimeTuningConfig makeDefaultTuningConfig(@Nullable File basePersistDirectory) {
        return new RealtimeTuningConfig(1000000, 0L, DEFAULT_INTERMEDIATE_PERSIST_PERIOD, DEFAULT_WINDOW_PERIOD, basePersistDirectory == null ? RealtimeTuningConfig.createNewBasePersistDirectory() : basePersistDirectory, DEFAULT_VERSIONING_POLICY, DEFAULT_REJECTION_POLICY_FACTORY, 0, DEFAULT_SHARD_SPEC, DEFAULT_INDEX_SPEC, DEFAULT_INDEX_SPEC, true, 0, 0, DEFAULT_REPORT_PARSE_EXCEPTIONS, 0L, 0L, null, DEFAULT_DEDUP_COLUMN);
    }

    @JsonCreator
    public RealtimeTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") Long maxBytesInMemory, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="windowPeriod") Period windowPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="versioningPolicy") VersioningPolicy versioningPolicy, @JsonProperty(value="rejectionPolicy") RejectionPolicyFactory rejectionPolicyFactory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="shardSpec") ShardSpec shardSpec, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="persistThreadPriority") int persistThreadPriority, @JsonProperty(value="mergeThreadPriority") int mergeThreadPriority, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="alertTimeout") Long alertTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="dedupColumn") @Nullable String dedupColumn) {
        this.maxRowsInMemory = maxRowsInMemory == null ? 1000000 : maxRowsInMemory;
        this.maxBytesInMemory = maxBytesInMemory == null ? 0L : maxBytesInMemory;
        this.intermediatePersistPeriod = intermediatePersistPeriod == null ? DEFAULT_INTERMEDIATE_PERSIST_PERIOD : intermediatePersistPeriod;
        this.windowPeriod = windowPeriod == null ? DEFAULT_WINDOW_PERIOD : windowPeriod;
        this.basePersistDirectory = basePersistDirectory == null ? RealtimeTuningConfig.createNewBasePersistDirectory() : basePersistDirectory;
        this.versioningPolicy = versioningPolicy == null ? DEFAULT_VERSIONING_POLICY : versioningPolicy;
        this.rejectionPolicyFactory = rejectionPolicyFactory == null ? DEFAULT_REJECTION_POLICY_FACTORY : rejectionPolicyFactory;
        this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
        this.shardSpec = shardSpec == null ? DEFAULT_SHARD_SPEC : shardSpec;
        this.indexSpec = indexSpec == null ? DEFAULT_INDEX_SPEC : indexSpec;
        this.indexSpecForIntermediatePersists = indexSpecForIntermediatePersists == null ? this.indexSpec : indexSpecForIntermediatePersists;
        this.mergeThreadPriority = mergeThreadPriority;
        this.persistThreadPriority = persistThreadPriority;
        this.reportParseExceptions = reportParseExceptions == null ? DEFAULT_REPORT_PARSE_EXCEPTIONS : reportParseExceptions;
        this.handoffConditionTimeout = handoffConditionTimeout == null ? 0L : handoffConditionTimeout;
        Preconditions.checkArgument(this.handoffConditionTimeout >= 0L, "handoffConditionTimeout must be >= 0");
        this.alertTimeout = alertTimeout == null ? 0L : alertTimeout;
        Preconditions.checkArgument(this.alertTimeout >= 0L, "alertTimeout must be >= 0");
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        this.dedupColumn = dedupColumn == null ? DEFAULT_DEDUP_COLUMN : dedupColumn;
    }

    @Override
    @JsonProperty
    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @Override
    @JsonProperty
    public long getMaxBytesInMemory() {
        return this.maxBytesInMemory;
    }

    @Override
    @JsonProperty
    public Period getIntermediatePersistPeriod() {
        return this.intermediatePersistPeriod;
    }

    @JsonProperty
    public Period getWindowPeriod() {
        return this.windowPeriod;
    }

    @Override
    @JsonProperty
    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    @JsonProperty
    public VersioningPolicy getVersioningPolicy() {
        return this.versioningPolicy;
    }

    @JsonProperty(value="rejectionPolicy")
    public RejectionPolicyFactory getRejectionPolicyFactory() {
        return this.rejectionPolicyFactory;
    }

    @Override
    @JsonProperty
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @Override
    public PartitionsSpec getPartitionsSpec() {
        throw new UnsupportedOperationException();
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    @Override
    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @Override
    @JsonProperty
    public IndexSpec getIndexSpecForIntermediatePersists() {
        return this.indexSpecForIntermediatePersists;
    }

    @Deprecated
    @JsonProperty
    public Boolean getBuildV9Directly() {
        return true;
    }

    @JsonProperty
    public int getPersistThreadPriority() {
        return this.persistThreadPriority;
    }

    @JsonProperty
    public int getMergeThreadPriority() {
        return this.mergeThreadPriority;
    }

    @Override
    @JsonProperty
    public boolean isReportParseExceptions() {
        return this.reportParseExceptions;
    }

    @JsonProperty
    public long getHandoffConditionTimeout() {
        return this.handoffConditionTimeout;
    }

    @JsonProperty
    public long getAlertTimeout() {
        return this.alertTimeout;
    }

    @Override
    @JsonProperty
    @Nullable
    public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
        return this.segmentWriteOutMediumFactory;
    }

    @JsonProperty
    @Nullable
    public String getDedupColumn() {
        return this.dedupColumn;
    }

    public RealtimeTuningConfig withVersioningPolicy(VersioningPolicy policy) {
        return new RealtimeTuningConfig(this.maxRowsInMemory, this.maxBytesInMemory, this.intermediatePersistPeriod, this.windowPeriod, this.basePersistDirectory, policy, this.rejectionPolicyFactory, this.maxPendingPersists, this.shardSpec, this.indexSpec, this.indexSpecForIntermediatePersists, true, this.persistThreadPriority, this.mergeThreadPriority, this.reportParseExceptions, this.handoffConditionTimeout, this.alertTimeout, this.segmentWriteOutMediumFactory, this.dedupColumn);
    }

    @Override
    public RealtimeTuningConfig withBasePersistDirectory(File dir) {
        return new RealtimeTuningConfig(this.maxRowsInMemory, this.maxBytesInMemory, this.intermediatePersistPeriod, this.windowPeriod, dir, this.versioningPolicy, this.rejectionPolicyFactory, this.maxPendingPersists, this.shardSpec, this.indexSpec, this.indexSpecForIntermediatePersists, true, this.persistThreadPriority, this.mergeThreadPriority, this.reportParseExceptions, this.handoffConditionTimeout, this.alertTimeout, this.segmentWriteOutMediumFactory, this.dedupColumn);
    }
}

