/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.incremental;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.Row;
import org.apache.hive.druid.org.apache.druid.data.input.impl.SpatialDimensionSchema;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class SpatialDimensionRowTransformer
implements Function<InputRow, InputRow> {
    private static final Joiner JOINER = Joiner.on(",");
    private static final Splitter SPLITTER = Splitter.on(",");
    private final Map<String, SpatialDimensionSchema> spatialDimensionMap = new HashMap<String, SpatialDimensionSchema>();
    private final Set<String> spatialPartialDimNames;

    public SpatialDimensionRowTransformer(List<SpatialDimensionSchema> spatialDimensions) {
        for (SpatialDimensionSchema spatialDimension : spatialDimensions) {
            if (this.spatialDimensionMap.put(spatialDimension.getDimName(), spatialDimension) == null) continue;
            throw new ISE("Duplicate spatial dimension names found! Check your schema yo!", new Object[0]);
        }
        this.spatialPartialDimNames = Sets.newHashSet(Iterables.concat(Lists.transform(spatialDimensions, new Function<SpatialDimensionSchema, List<String>>(){

            @Override
            public List<String> apply(SpatialDimensionSchema input) {
                return input.getDims();
            }
        })));
    }

    @Override
    public InputRow apply(final InputRow row) {
        final HashMap<String, List<String>> spatialLookup = new HashMap<String, List<String>>();
        final ArrayList<String> finalDims = Lists.newArrayList(Iterables.filter(row.getDimensions(), new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return !SpatialDimensionRowTransformer.this.spatialDimensionMap.containsKey(input) && !SpatialDimensionRowTransformer.this.spatialPartialDimNames.contains(input);
            }
        }));
        InputRow retVal = new InputRow(){

            @Override
            public List<String> getDimensions() {
                return finalDims;
            }

            @Override
            public long getTimestampFromEpoch() {
                return row.getTimestampFromEpoch();
            }

            @Override
            public DateTime getTimestamp() {
                return row.getTimestamp();
            }

            @Override
            public List<String> getDimension(String dimension) {
                List<String> retVal = (List<String>)spatialLookup.get(dimension);
                return retVal == null ? row.getDimension(dimension) : retVal;
            }

            @Override
            public Object getRaw(String dimension) {
                List retVal = (List)spatialLookup.get(dimension);
                return retVal == null ? row.getRaw(dimension) : retVal;
            }

            @Override
            public Number getMetric(String metric) {
                return row.getMetric(metric);
            }

            public String toString() {
                return row.toString();
            }

            @Override
            public int compareTo(Row o) {
                return this.getTimestamp().compareTo((ReadableInstant)o.getTimestamp());
            }
        };
        for (Map.Entry<String, SpatialDimensionSchema> entry : this.spatialDimensionMap.entrySet()) {
            String spatialDimName = entry.getKey();
            SpatialDimensionSchema spatialDim = entry.getValue();
            List<String> dimVals = row.getDimension(spatialDimName);
            if (dimVals != null && !dimVals.isEmpty()) {
                if (dimVals.size() != 1) {
                    throw new ISE("Spatial dimension value must be in an array!", new Object[0]);
                }
                if (!this.isJoinedSpatialDimValValid(dimVals.get(0))) continue;
                spatialLookup.put(spatialDimName, dimVals);
                finalDims.add(spatialDimName);
                continue;
            }
            ArrayList<String> spatialDimVals = new ArrayList<String>();
            for (String dim : spatialDim.getDims()) {
                List<String> partialDimVals = row.getDimension(dim);
                if (!this.isSpatialDimValsValid(partialDimVals)) continue;
                spatialDimVals.addAll(partialDimVals);
            }
            if (spatialDimVals.size() != spatialDim.getDims().size()) continue;
            spatialLookup.put(spatialDimName, Collections.singletonList(JOINER.join(spatialDimVals)));
            finalDims.add(spatialDimName);
        }
        return retVal;
    }

    private boolean isSpatialDimValsValid(List<String> dimVals) {
        if (dimVals == null || dimVals.isEmpty()) {
            return false;
        }
        for (String dimVal : dimVals) {
            if (SpatialDimensionRowTransformer.tryParseFloat(dimVal) != null) continue;
            return false;
        }
        return true;
    }

    private boolean isJoinedSpatialDimValValid(String dimVal) {
        if (dimVal == null || dimVal.isEmpty()) {
            return false;
        }
        Iterable<String> dimVals = SPLITTER.split(dimVal);
        for (String val : dimVals) {
            if (SpatialDimensionRowTransformer.tryParseFloat(val) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Float tryParseFloat(String val) {
        try {
            return Float.valueOf(Float.parseFloat(val));
        }
        catch (NullPointerException | NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static float[] decode(String encodedCoordinate) {
        if (encodedCoordinate == null) {
            return null;
        }
        ImmutableList<String> parts = ImmutableList.copyOf(SPLITTER.split(encodedCoordinate));
        float[] coordinate = new float[parts.size()];
        for (int i = 0; i < coordinate.length; ++i) {
            Float floatPart = SpatialDimensionRowTransformer.tryParseFloat((String)parts.get(i));
            if (floatPart == null) {
                return null;
            }
            coordinate[i] = floatPart.floatValue();
        }
        return coordinate;
    }
}

