/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.incremental;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.org.apache.druid.segment.DimensionIndexer;
import org.apache.hive.druid.org.apache.druid.segment.IndexableAdapter;
import org.apache.hive.druid.org.apache.druid.segment.IntIteratorUtils;
import org.apache.hive.druid.org.apache.druid.segment.Metadata;
import org.apache.hive.druid.org.apache.druid.segment.TransformableRowIterator;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapValues;
import org.apache.hive.druid.org.apache.druid.segment.data.CloseableIndexed;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexRowIterator;
import org.joda.time.Interval;

public class IncrementalIndexAdapter
implements IndexableAdapter {
    private final Interval dataInterval;
    private final IncrementalIndex<?> index;
    private final Map<String, DimensionAccessor> accessors;

    public IncrementalIndexAdapter(Interval dataInterval, IncrementalIndex<?> index, BitmapFactory bitmapFactory) {
        this.dataInterval = dataInterval;
        this.index = index;
        List<IncrementalIndex.DimensionDesc> dimensions = index.getDimensions();
        this.accessors = dimensions.stream().collect(Collectors.toMap(IncrementalIndex.DimensionDesc::getName, DimensionAccessor::new));
        this.processRows(index, bitmapFactory, dimensions);
    }

    private void processRows(IncrementalIndex<?> index, BitmapFactory bitmapFactory, List<IncrementalIndex.DimensionDesc> dimensions) {
        int rowNum = 0;
        for (IncrementalIndexRow row : index.getFacts().persistIterable()) {
            Object[] dims = row.getDims();
            for (IncrementalIndex.DimensionDesc dimension : dimensions) {
                int dimIndex = dimension.getIndex();
                DimensionAccessor accessor = this.accessors.get(dimension.getName());
                if (dimIndex >= dims.length || dims[dimIndex] == null) {
                    accessor.indexer.processRowValsToUnsortedEncodedKeyComponent(null, true);
                    continue;
                }
                ColumnCapabilitiesImpl capabilities = dimension.getCapabilities();
                if (!capabilities.hasBitmapIndexes()) continue;
                MutableBitmap[] bitmapIndexes = accessor.invertedIndexes;
                DimensionIndexer indexer = accessor.indexer;
                indexer.fillBitmapsFromUnsortedEncodedKeyComponent(dims[dimIndex], rowNum, bitmapIndexes, bitmapFactory);
            }
            ++rowNum;
        }
    }

    @Override
    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Override
    public int getNumRows() {
        return this.index.size();
    }

    @Override
    public List<String> getDimensionNames() {
        return this.index.getDimensionNames();
    }

    @Override
    public List<String> getMetricNames() {
        return this.index.getMetricNames();
    }

    @Override
    @Nullable
    public <T extends Comparable<? super T>> CloseableIndexed<T> getDimValueLookup(String dimension) {
        DimensionAccessor accessor = this.accessors.get(dimension);
        if (accessor == null) {
            return null;
        }
        DimensionIndexer indexer = accessor.dimensionDesc.getIndexer();
        return indexer.getSortedIndexedValues();
    }

    @Override
    public TransformableRowIterator getRows() {
        return new IncrementalIndexRowIterator(this.index);
    }

    @Override
    public BitmapValues getBitmapValues(String dimension, int index) {
        DimensionAccessor accessor = this.accessors.get(dimension);
        if (accessor == null) {
            return BitmapValues.EMPTY;
        }
        ColumnCapabilitiesImpl capabilities = accessor.dimensionDesc.getCapabilities();
        DimensionIndexer indexer = accessor.dimensionDesc.getIndexer();
        if (!capabilities.hasBitmapIndexes()) {
            return BitmapValues.EMPTY;
        }
        int id = indexer.getUnsortedEncodedValueFromSorted(index);
        if (id < 0 || id >= indexer.getCardinality()) {
            return BitmapValues.EMPTY;
        }
        MutableBitmap bitmapIndex = accessor.invertedIndexes[id];
        if (bitmapIndex == null) {
            return BitmapValues.EMPTY;
        }
        return new MutableBitmapValues(bitmapIndex);
    }

    @Override
    public String getMetricType(String metric) {
        return this.index.getMetricType(metric);
    }

    @Override
    public ColumnCapabilities getCapabilities(String column) {
        return this.index.getCapabilities(column);
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    static class MutableBitmapValues
    implements BitmapValues {
        private final MutableBitmap bitmapIndex;

        MutableBitmapValues(MutableBitmap bitmapIndex) {
            this.bitmapIndex = bitmapIndex;
        }

        @Override
        public int size() {
            return this.bitmapIndex.size();
        }

        @Override
        public IntIterator iterator() {
            return IntIteratorUtils.fromRoaringBitmapIntIterator(this.bitmapIndex.iterator());
        }
    }

    private static class DimensionAccessor {
        private final IncrementalIndex.DimensionDesc dimensionDesc;
        @Nullable
        private final MutableBitmap[] invertedIndexes;
        private final DimensionIndexer indexer;

        public DimensionAccessor(IncrementalIndex.DimensionDesc dimensionDesc) {
            this.dimensionDesc = dimensionDesc;
            this.indexer = dimensionDesc.getIndexer();
            this.invertedIndexes = dimensionDesc.getCapabilities().hasBitmapIndexes() ? new MutableBitmap[this.indexer.getCardinality() + 1] : null;
        }
    }
}

