/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.filter;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.hive.druid.org.apache.druid.query.BitmapResultFactory;
import org.apache.hive.druid.org.apache.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.org.apache.druid.query.filter.BooleanFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.FilterTuning;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcherColumnSelectorStrategyFactory;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.org.apache.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnHolder;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.data.CloseableIndexed;
import org.apache.hive.druid.org.apache.druid.segment.data.Indexed;
import org.apache.hive.druid.org.apache.druid.segment.filter.AndFilter;
import org.apache.hive.druid.org.apache.druid.segment.filter.NotFilter;
import org.apache.hive.druid.org.apache.druid.segment.filter.OrFilter;

public class Filters {
    private static final String CTX_KEY_USE_FILTER_CNF = "useFilterCNF";

    public static List<Filter> toFilters(List<DimFilter> dimFilters) {
        return ImmutableList.copyOf(FunctionalIterable.create(dimFilters).transform(new Function<DimFilter, Filter>(){

            @Override
            public Filter apply(DimFilter input) {
                return input.toFilter();
            }
        }));
    }

    @Nullable
    public static Filter toFilter(@Nullable DimFilter dimFilter) {
        return dimFilter == null ? null : dimFilter.toFilter();
    }

    public static ValueMatcher makeValueMatcher(ColumnSelectorFactory columnSelectorFactory, String columnName, String value) {
        ColumnSelectorPlus<ValueMatcherColumnSelectorStrategy> selector = DimensionHandlerUtils.createColumnSelectorPlus(ValueMatcherColumnSelectorStrategyFactory.instance(), DefaultDimensionSpec.of(columnName), columnSelectorFactory);
        return selector.getColumnSelectorStrategy().makeValueMatcher(selector.getSelector(), value);
    }

    public static ValueMatcher makeValueMatcher(ColumnSelectorFactory columnSelectorFactory, String columnName, DruidPredicateFactory predicateFactory) {
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(columnName);
        if (capabilities != null && capabilities.getType() == ValueType.LONG) {
            return Filters.getLongPredicateMatcher(columnSelectorFactory.makeColumnValueSelector(columnName), predicateFactory.makeLongPredicate());
        }
        ColumnSelectorPlus<ValueMatcherColumnSelectorStrategy> selector = DimensionHandlerUtils.createColumnSelectorPlus(ValueMatcherColumnSelectorStrategyFactory.instance(), DefaultDimensionSpec.of(columnName), columnSelectorFactory);
        return selector.getColumnSelectorStrategy().makeValueMatcher(selector.getSelector(), predicateFactory);
    }

    public static ImmutableBitmap allFalse(BitmapIndexSelector selector) {
        return selector.getBitmapFactory().makeEmptyImmutableBitmap();
    }

    public static ImmutableBitmap allTrue(BitmapIndexSelector selector) {
        return selector.getBitmapFactory().complement(selector.getBitmapFactory().makeEmptyImmutableBitmap(), selector.getNumRows());
    }

    static Iterable<ImmutableBitmap> bitmapsFromIndexes(final IntIterable indexes, final BitmapIndex bitmapIndex) {
        return new Iterable<ImmutableBitmap>(){

            @Override
            public Iterator<ImmutableBitmap> iterator() {
                final IntIterator iterator = indexes.iterator();
                return new Iterator<ImmutableBitmap>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public ImmutableBitmap next() {
                        return bitmapIndex.getBitmap(iterator.nextInt());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> T matchPredicate(String dimension, BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory, Predicate<String> predicate) {
        return bitmapResultFactory.unionDimensionValueBitmaps(Filters.matchPredicateNoUnion(dimension, selector, predicate));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Iterable<ImmutableBitmap> matchPredicateNoUnion(String dimension, BitmapIndexSelector selector, Predicate<String> predicate) {
        Preconditions.checkNotNull(dimension, "dimension");
        Preconditions.checkNotNull(selector, "selector");
        Preconditions.checkNotNull(predicate, "predicate");
        try (CloseableIndexed<String> dimValues = selector.getDimensionValues(dimension);){
            if (dimValues == null || dimValues.size() == 0) {
                ImmutableList<ImmutableBitmap> immutableList = ImmutableList.of(predicate.apply(null) ? Filters.allTrue(selector) : Filters.allFalse(selector));
                return immutableList;
            }
            BitmapIndex bitmapIndex = selector.getBitmapIndex(dimension);
            Iterable<ImmutableBitmap> iterable = Filters.makePredicateQualifyingBitmapIterable(bitmapIndex, predicate, dimValues);
            return iterable;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static double estimateSelectivity(String dimension, BitmapIndexSelector indexSelector, Predicate<String> predicate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static double estimateSelectivity(BitmapIndex bitmapIndex, IntList bitmaps, long totalNumRows) {
        long numMatchedRows = 0L;
        for (int i = 0; i < bitmaps.size(); ++i) {
            ImmutableBitmap bitmap = bitmapIndex.getBitmap(bitmaps.getInt(i));
            numMatchedRows += (long)bitmap.size();
        }
        return Math.min(1.0, (double)numMatchedRows / (double)totalNumRows);
    }

    public static double estimateSelectivity(Iterator<ImmutableBitmap> bitmaps, long totalNumRows) {
        long numMatchedRows = 0L;
        while (bitmaps.hasNext()) {
            ImmutableBitmap bitmap = bitmaps.next();
            numMatchedRows += (long)bitmap.size();
        }
        return Math.min(1.0, (double)numMatchedRows / (double)totalNumRows);
    }

    private static Iterable<ImmutableBitmap> makePredicateQualifyingBitmapIterable(BitmapIndex bitmapIndex, Predicate<String> predicate, Indexed<String> dimValues) {
        return Filters.bitmapsFromIndexes(Filters.makePredicateQualifyingIndexIterable(bitmapIndex, predicate, dimValues), bitmapIndex);
    }

    private static IntIterable makePredicateQualifyingIndexIterable(final BitmapIndex bitmapIndex, final Predicate<String> predicate, final Indexed<String> dimValues) {
        return new IntIterable(){

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    private final int bitmapIndexCardinality;
                    private int nextIndex;
                    private int found;
                    {
                        this.bitmapIndexCardinality = bitmapIndex.getCardinality();
                        this.nextIndex = 0;
                        this.found = this.findNextIndex();
                    }

                    private int findNextIndex() {
                        while (this.nextIndex < this.bitmapIndexCardinality && !predicate.apply(dimValues.get(this.nextIndex))) {
                            ++this.nextIndex;
                        }
                        if (this.nextIndex < this.bitmapIndexCardinality) {
                            return this.nextIndex++;
                        }
                        return -1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.found != -1;
                    }

                    @Override
                    public int nextInt() {
                        int foundIndex = this.found;
                        if (foundIndex == -1) {
                            throw new NoSuchElementException();
                        }
                        this.found = this.findNextIndex();
                        return foundIndex;
                    }
                };
            }
        };
    }

    static boolean supportsSelectivityEstimation(Filter filter, String dimension, ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        ColumnHolder columnHolder;
        if (filter.supportsBitmapIndex(indexSelector) && (columnHolder = columnSelector.getColumnHolder(dimension)) != null) {
            return !columnHolder.getCapabilities().hasMultipleValues();
        }
        return false;
    }

    public static ValueMatcher getLongPredicateMatcher(final BaseLongColumnValueSelector longSelector, final DruidLongPredicate predicate) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return predicate.applyLong(longSelector.getLong());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("longSelector", longSelector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Nullable
    public static Filter convertToCNFFromQueryContext(Query query, @Nullable Filter filter) {
        if (filter == null) {
            return null;
        }
        boolean useCNF = query.getContextBoolean(CTX_KEY_USE_FILTER_CNF, false);
        return useCNF ? Filters.convertToCNF(filter) : filter;
    }

    public static Filter convertToCNF(Filter current) {
        current = Filters.pushDownNot(current);
        current = Filters.flatten(current);
        current = Filters.convertToCNFInternal(current);
        current = Filters.flatten(current);
        return current;
    }

    private static Filter pushDownNot(Filter current) {
        ArrayList<Filter> children;
        if (current instanceof NotFilter) {
            Filter child = ((NotFilter)current).getBaseFilter();
            if (child instanceof NotFilter) {
                return Filters.pushDownNot(((NotFilter)child).getBaseFilter());
            }
            if (child instanceof AndFilter) {
                ArrayList<Filter> children2 = new ArrayList<Filter>();
                for (Filter grandChild : ((AndFilter)child).getFilters()) {
                    children2.add(Filters.pushDownNot(new NotFilter(grandChild)));
                }
                return new OrFilter(children2);
            }
            if (child instanceof OrFilter) {
                ArrayList<Filter> children3 = new ArrayList<Filter>();
                for (Filter grandChild : ((OrFilter)child).getFilters()) {
                    children3.add(Filters.pushDownNot(new NotFilter(grandChild)));
                }
                return new AndFilter(children3);
            }
        }
        if (current instanceof AndFilter) {
            children = new ArrayList<Filter>();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(Filters.pushDownNot(child));
            }
            return new AndFilter(children);
        }
        if (current instanceof OrFilter) {
            children = new ArrayList();
            for (Filter child : ((OrFilter)current).getFilters()) {
                children.add(Filters.pushDownNot(child));
            }
            return new OrFilter(children);
        }
        return current;
    }

    private static Filter convertToCNFInternal(Filter current) {
        if (current instanceof NotFilter) {
            return new NotFilter(Filters.convertToCNFInternal(((NotFilter)current).getBaseFilter()));
        }
        if (current instanceof AndFilter) {
            ArrayList<Filter> children = new ArrayList<Filter>();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(Filters.convertToCNFInternal(child));
            }
            return new AndFilter(children);
        }
        if (current instanceof OrFilter) {
            ArrayList<Filter> nonAndList = new ArrayList<Filter>();
            ArrayList<Filter> andList = new ArrayList<Filter>();
            for (Filter child : ((OrFilter)current).getFilters()) {
                if (child instanceof AndFilter) {
                    andList.add(child);
                    continue;
                }
                if (child instanceof OrFilter) {
                    for (Filter grandChild : ((OrFilter)child).getFilters()) {
                        nonAndList.add(grandChild);
                    }
                    continue;
                }
                nonAndList.add(child);
            }
            if (!andList.isEmpty()) {
                ArrayList<Filter> result = new ArrayList<Filter>();
                Filters.generateAllCombinations(result, andList, nonAndList);
                return new AndFilter(result);
            }
        }
        return current;
    }

    private static Filter flatten(Filter root) {
        if (root instanceof BooleanFilter) {
            ArrayList<Filter> children = new ArrayList<Filter>();
            children.addAll(((BooleanFilter)root).getFilters());
            for (int i = 0; i < children.size(); ++i) {
                Filter child = Filters.flatten((Filter)children.get(i));
                if (child.getClass() == root.getClass() && !(child instanceof NotFilter)) {
                    boolean first = true;
                    List<Filter> grandKids = ((BooleanFilter)child).getFilters();
                    for (Filter grandkid : grandKids) {
                        if (first) {
                            first = false;
                            children.set(i, grandkid);
                            continue;
                        }
                        children.add(++i, grandkid);
                    }
                    continue;
                }
                children.set(i, child);
            }
            if (children.size() == 1 && (root instanceof AndFilter || root instanceof OrFilter)) {
                return (Filter)children.get(0);
            }
            if (root instanceof AndFilter) {
                return new AndFilter(children);
            }
            if (root instanceof OrFilter) {
                return new OrFilter(children);
            }
        }
        return root;
    }

    private static void generateAllCombinations(List<Filter> result, List<Filter> andList, List<Filter> nonAndList) {
        List<Filter> children = ((AndFilter)andList.get(0)).getFilters();
        if (result.isEmpty()) {
            for (Filter child : children) {
                ArrayList<Filter> a = Lists.newArrayList(nonAndList);
                a.add(child);
                result.add(new OrFilter(a));
            }
        } else {
            ArrayList<Filter> work = new ArrayList<Filter>(result);
            result.clear();
            for (Filter child : children) {
                for (Filter or : work) {
                    ArrayList<Filter> a = Lists.newArrayList(((OrFilter)or).getFilters());
                    a.add(child);
                    result.add(new OrFilter(a));
                }
            }
        }
        if (andList.size() > 1) {
            Filters.generateAllCombinations(result, andList.subList(1, andList.size()), nonAndList);
        }
    }

    public static boolean shouldUseBitmapIndex(Filter filter, BitmapIndexSelector indexSelector, @Nullable FilterTuning filterTuning) {
        FilterTuning tuning;
        FilterTuning filterTuning2 = tuning = filterTuning != null ? filterTuning : FilterTuning.createDefault(filter, indexSelector);
        if (filter.supportsBitmapIndex(indexSelector) && tuning.getUseBitmapIndex()) {
            return filter.getRequiredColumns().stream().allMatch(column -> {
                BitmapIndex index = indexSelector.getBitmapIndex((String)column);
                Preconditions.checkNotNull(index, "Column does not have a bitmap index");
                int cardinality = index.getCardinality();
                return cardinality >= tuning.getMinCardinalityToUseBitmapIndex() && cardinality <= tuning.getMaxCardinalityToUseBitmapIndex();
            });
        }
        return false;
    }
}

