/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.BitmapResultFactory;
import org.apache.hive.druid.org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.org.apache.druid.query.filter.BooleanFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.RowOffsetMatcherFactory;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.filter.Filters;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class AndFilter
implements BooleanFilter {
    private static final Joiner AND_JOINER = Joiner.on(" && ");
    static final ValueMatcher[] EMPTY_VALUE_MATCHER_ARRAY = new ValueMatcher[0];
    private final List<Filter> filters;

    public AndFilter(List<Filter> filters) {
        Preconditions.checkArgument(filters.size() > 0, "Can't construct empty AndFilter");
        this.filters = filters;
    }

    public static <T> ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory, List<Filter> filters) {
        return bitmapResultFactory.toImmutableBitmap(AndFilter.getBitmapResult(selector, bitmapResultFactory, filters));
    }

    private static <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory, List<Filter> filters) {
        if (filters.size() == 1) {
            return filters.get(0).getBitmapResult(selector, bitmapResultFactory);
        }
        ArrayList<T> bitmapResults = Lists.newArrayListWithCapacity(filters.size());
        for (Filter filter : filters) {
            Preconditions.checkArgument(filter.supportsBitmapIndex(selector), "Filter[%s] does not support bitmap index", filter);
            T bitmapResult = filter.getBitmapResult(selector, bitmapResultFactory);
            if (bitmapResultFactory.isEmpty(bitmapResult)) {
                return bitmapResultFactory.wrapAllFalse(Filters.allFalse(selector));
            }
            bitmapResults.add(bitmapResult);
        }
        return bitmapResultFactory.intersection(bitmapResults);
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return AndFilter.getBitmapResult(selector, bitmapResultFactory, this.filters);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        for (int i = 0; i < this.filters.size(); ++i) {
            matchers[i] = this.filters.get(i).makeMatcher(factory);
        }
        return AndFilter.makeMatcher(matchers);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        VectorValueMatcher[] matchers = new VectorValueMatcher[this.filters.size()];
        for (int i = 0; i < this.filters.size(); ++i) {
            matchers[i] = this.filters.get(i).makeVectorMatcher(factory);
        }
        return AndFilter.makeVectorMatcher(matchers);
    }

    @Override
    public boolean canVectorizeMatcher() {
        return this.filters.stream().allMatch(Filter::canVectorizeMatcher);
    }

    @Override
    public ValueMatcher makeMatcher(BitmapIndexSelector selector, ColumnSelectorFactory columnSelectorFactory, RowOffsetMatcherFactory rowOffsetMatcherFactory) {
        ArrayList<ValueMatcher> matchers = new ArrayList<ValueMatcher>();
        ArrayList<ImmutableBitmap> bitmaps = new ArrayList<ImmutableBitmap>();
        for (Filter filter : this.filters) {
            if (filter.supportsBitmapIndex(selector)) {
                bitmaps.add(filter.getBitmapIndex(selector));
                continue;
            }
            ValueMatcher matcher = filter.makeMatcher(columnSelectorFactory);
            matchers.add(matcher);
        }
        if (bitmaps.size() > 0) {
            ImmutableBitmap combinedBitmap = selector.getBitmapFactory().intersection(bitmaps);
            ValueMatcher offsetMatcher = rowOffsetMatcherFactory.makeRowOffsetMatcher(combinedBitmap);
            matchers.add(0, offsetMatcher);
        }
        return AndFilter.makeMatcher(matchers.toArray(EMPTY_VALUE_MATCHER_ARRAY));
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        double selectivity = 1.0;
        for (Filter filter : this.filters) {
            selectivity *= filter.estimateSelectivity(indexSelector);
        }
        return selectivity;
    }

    public String toString() {
        return StringUtils.format("(%s)", AND_JOINER.join(this.filters));
    }

    private static ValueMatcher makeMatcher(final ValueMatcher[] baseMatchers) {
        Preconditions.checkState(baseMatchers.length > 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                for (ValueMatcher matcher : baseMatchers) {
                    if (matcher.matches()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("firstBaseMatcher", baseMatchers[0]);
                inspector.visit("secondBaseMatcher", baseMatchers[1]);
            }
        };
    }

    private static VectorValueMatcher makeVectorMatcher(final VectorValueMatcher[] baseMatchers) {
        Preconditions.checkState(baseMatchers.length > 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new BaseVectorValueMatcher(baseMatchers[0]){

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                ReadableVectorMatch match = mask;
                for (VectorValueMatcher matcher : baseMatchers) {
                    if (match.isAllFalse()) break;
                    match = matcher.match(match);
                }
                assert (match.isValid(mask));
                return match;
            }
        };
    }
}

