/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.org.apache.druid.io.Channels;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarInts;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedIterable;
import org.apache.hive.druid.org.apache.druid.segment.data.SliceIndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.data.WritableSupplier;

public class CompressedVSizeColumnarMultiIntsSupplier
implements WritableSupplier<ColumnarMultiInts> {
    private static final byte VERSION = 2;
    private final CompressedVSizeColumnarIntsSupplier offsetSupplier;
    private final CompressedVSizeColumnarIntsSupplier valueSupplier;

    private CompressedVSizeColumnarMultiIntsSupplier(CompressedVSizeColumnarIntsSupplier offsetSupplier, CompressedVSizeColumnarIntsSupplier valueSupplier) {
        this.offsetSupplier = offsetSupplier;
        this.valueSupplier = valueSupplier;
    }

    @Override
    public long getSerializedSize() {
        return 1L + this.offsetSupplier.getSerializedSize() + this.valueSupplier.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Channels.writeFully(channel, ByteBuffer.wrap(new byte[]{2}));
        this.offsetSupplier.writeTo(channel, smoosher);
        this.valueSupplier.writeTo(channel, smoosher);
    }

    public static CompressedVSizeColumnarMultiIntsSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 2) {
            CompressedVSizeColumnarIntsSupplier offsetSupplier = CompressedVSizeColumnarIntsSupplier.fromByteBuffer(buffer, order);
            CompressedVSizeColumnarIntsSupplier valueSupplier = CompressedVSizeColumnarIntsSupplier.fromByteBuffer(buffer, order);
            return new CompressedVSizeColumnarMultiIntsSupplier(offsetSupplier, valueSupplier);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    @VisibleForTesting
    public static CompressedVSizeColumnarMultiIntsSupplier fromIterable(Iterable<IndexedInts> objectsIterable, int maxValue, ByteOrder byteOrder, CompressionStrategy compression, Closer closer) {
        Iterator<IndexedInts> objects = objectsIterable.iterator();
        IntArrayList offsetList = new IntArrayList();
        IntArrayList values = new IntArrayList();
        int offset = 0;
        while (objects.hasNext()) {
            IndexedInts next = objects.next();
            offsetList.add(offset);
            int size = next.size();
            for (int i = 0; i < size; ++i) {
                values.add(next.get(i));
            }
            offset += next.size();
        }
        offsetList.add(offset);
        int offsetMax = offset;
        CompressedVSizeColumnarIntsSupplier headerSupplier = CompressedVSizeColumnarIntsSupplier.fromList(offsetList, offsetMax, CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue(offsetMax), byteOrder, compression, closer);
        CompressedVSizeColumnarIntsSupplier valuesSupplier = CompressedVSizeColumnarIntsSupplier.fromList(values, maxValue, CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue(maxValue), byteOrder, compression, closer);
        return new CompressedVSizeColumnarMultiIntsSupplier(headerSupplier, valuesSupplier);
    }

    @Override
    public ColumnarMultiInts get() {
        return new CompressedVSizeColumnarMultiInts(this.offsetSupplier.get(), this.valueSupplier.get());
    }

    public static class CompressedVSizeColumnarMultiInts
    implements ColumnarMultiInts {
        private final ColumnarInts offsets;
        private final ColumnarInts values;
        private final SliceIndexedInts rowValues;

        CompressedVSizeColumnarMultiInts(ColumnarInts offsets, ColumnarInts values) {
            this.offsets = offsets;
            this.values = values;
            this.rowValues = new SliceIndexedInts(values);
        }

        @Override
        public void close() throws IOException {
            this.offsets.close();
            this.values.close();
        }

        @Override
        public int size() {
            return this.offsets.size() - 1;
        }

        @Override
        public IndexedInts get(int index) {
            int offset = this.offsets.get(index);
            int size = this.offsets.get(index + 1) - offset;
            this.rowValues.setValues(offset, size);
            return this.rowValues;
        }

        @Override
        public IndexedInts getUnshared(int index) {
            final int offset = this.offsets.get(index);
            final int size = this.offsets.get(index + 1) - offset;
            class UnsharedIndexedInts
            implements IndexedInts {
                UnsharedIndexedInts() {
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public int get(int index) {
                    if (index >= size) {
                        throw new IAE("Index[%d] >= size[%d]", index, size);
                    }
                    return CompressedVSizeColumnarMultiInts.this.values.get(index + offset);
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("values", CompressedVSizeColumnarMultiInts.this.values);
                }
            }
            return new UnsharedIndexedInts();
        }

        @Override
        public int indexOf(IndexedInts value) {
            throw new UnsupportedOperationException("Reverse lookup not allowed.");
        }

        @Override
        public Iterator<IndexedInts> iterator() {
            return IndexedIterable.create(this).iterator();
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("offsets", this.offsets);
            inspector.visit("values", this.values);
        }
    }
}

