/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.hive.druid.org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class CompressedColumnarIntsSerializer
extends SingleValueColumnarIntsSerializer {
    private static final byte VERSION = 2;
    private static final MetaSerdeHelper<CompressedColumnarIntsSerializer> META_SERDE_HELPER = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.numInserted).writeInt(x -> x.chunkFactor).writeByte(x -> x.compression.getId());
    private final int chunkFactor;
    private final CompressionStrategy compression;
    private final GenericIndexedWriter<ByteBuffer> flattener;
    private int numInserted;
    @Nullable
    private ByteBuffer endBuffer;

    CompressedColumnarIntsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, int chunkFactor, ByteOrder byteOrder, CompressionStrategy compression) {
        this(segmentWriteOutMedium, chunkFactor, byteOrder, compression, GenericIndexedWriter.ofCompressedByteBuffers(segmentWriteOutMedium, filenameBase, compression, chunkFactor * 4));
    }

    CompressedColumnarIntsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, int chunkFactor, ByteOrder byteOrder, CompressionStrategy compression, GenericIndexedWriter<ByteBuffer> flattener) {
        this.chunkFactor = chunkFactor;
        this.compression = compression;
        this.flattener = flattener;
        CompressionStrategy.Compressor compressor = compression.getCompressor();
        Closer closer = segmentWriteOutMedium.getCloser();
        this.endBuffer = compressor.allocateInBuffer(chunkFactor * 4, closer).order(byteOrder);
        this.numInserted = 0;
    }

    @Override
    public void open() throws IOException {
        this.flattener.open();
    }

    @Override
    public void addValue(int val) throws IOException {
        if (this.endBuffer == null) {
            throw new IllegalStateException("written out already");
        }
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write(this.endBuffer);
            this.endBuffer.clear();
        }
        this.endBuffer.putInt(val);
        ++this.numInserted;
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writeEndBuffer();
        return (long)META_SERDE_HELPER.size(this) + this.flattener.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeEndBuffer();
        META_SERDE_HELPER.writeTo(channel, this);
        this.flattener.writeTo(channel, smoosher);
    }

    private void writeEndBuffer() throws IOException {
        if (this.endBuffer != null) {
            this.endBuffer.flip();
            if (this.endBuffer.remaining() > 0) {
                this.flattener.write(this.endBuffer);
            }
            this.endBuffer = null;
        }
    }
}

