/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import java.io.Closeable;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.data.ReadableOffset;
import org.apache.hive.druid.org.apache.druid.segment.historical.HistoricalColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.vector.BaseFloatVectorValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorSelectorUtils;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.hive.druid.org.roaringbitmap.PeekableIntIterator;

public interface ColumnarFloats
extends Closeable {
    public int size();

    public float get(int var1);

    default public void get(float[] out, int start, int length) {
        for (int i = 0; i < length; ++i) {
            out[i] = this.get(i + start);
        }
    }

    default public void get(float[] out, int[] indexes, int length) {
        for (int i = 0; i < length; ++i) {
            out[i] = this.get(indexes[i]);
        }
    }

    @Override
    public void close();

    default public ColumnValueSelector<Float> makeColumnValueSelector(final ReadableOffset offset, final ImmutableBitmap nullValueBitmap) {
        if (nullValueBitmap.isEmpty()) {
            class HistoricalFloatColumnSelector
            implements FloatColumnSelector,
            HistoricalColumnSelector<Float> {
                HistoricalFloatColumnSelector() {
                }

                @Override
                public boolean isNull() {
                    return false;
                }

                @Override
                public float getFloat() {
                    return ColumnarFloats.this.get(offset.getOffset());
                }

                @Override
                public double getDouble(int offset2) {
                    return ColumnarFloats.this.get(offset2);
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("columnar", ColumnarFloats.this);
                    inspector.visit("offset", offset);
                }
            }
            return new HistoricalFloatColumnSelector();
        }
        class HistoricalFloatColumnSelectorwithNulls
        implements FloatColumnSelector,
        HistoricalColumnSelector<Float> {
            private PeekableIntIterator nullIterator;
            private int nullMark;
            private int offsetMark;

            HistoricalFloatColumnSelectorwithNulls() {
                this.nullIterator = nullValueBitmap.peekableIterator();
                this.nullMark = -1;
                this.offsetMark = -1;
            }

            @Override
            public boolean isNull() {
                int i = offset.getOffset();
                if (i < this.offsetMark) {
                    this.nullMark = -1;
                    this.nullIterator = nullValueBitmap.peekableIterator();
                }
                this.offsetMark = i;
                if (this.nullMark < i) {
                    this.nullIterator.advanceIfNeeded(this.offsetMark);
                    if (this.nullIterator.hasNext()) {
                        this.nullMark = this.nullIterator.next();
                    }
                }
                return this.nullMark == this.offsetMark;
            }

            @Override
            public float getFloat() {
                assert (NullHandling.replaceWithDefault() || !this.isNull());
                return ColumnarFloats.this.get(offset.getOffset());
            }

            @Override
            public double getDouble(int offset2) {
                assert (NullHandling.replaceWithDefault() || !nullValueBitmap.get(offset2));
                return ColumnarFloats.this.get(offset2);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("columnar", ColumnarFloats.this);
                inspector.visit("offset", offset);
                inspector.visit("nullValueBitmap", nullValueBitmap);
            }
        }
        return new HistoricalFloatColumnSelectorwithNulls();
    }

    default public VectorValueSelector makeVectorValueSelector(final ReadableVectorOffset theOffset, final ImmutableBitmap nullValueBitmap) {
        class ColumnarFloatsVectorValueSelector
        extends BaseFloatVectorValueSelector {
            private final float[] floatVector;
            private int id;
            private PeekableIntIterator nullIterator;
            private int offsetMark;
            @Nullable
            private boolean[] nullVector;

            ColumnarFloatsVectorValueSelector() {
                super(readableVectorOffset);
                this.id = -1;
                this.nullIterator = nullValueBitmap.peekableIterator();
                this.offsetMark = -1;
                this.nullVector = null;
                this.floatVector = new float[this.offset.getMaxVectorSize()];
            }

            @Override
            @Nullable
            public boolean[] getNullVector() {
                this.computeVectorsIfNeeded();
                return this.nullVector;
            }

            @Override
            public float[] getFloatVector() {
                this.computeVectorsIfNeeded();
                return this.floatVector;
            }

            private void computeVectorsIfNeeded() {
                if (this.id == this.offset.getId()) {
                    return;
                }
                if (this.offset.isContiguous()) {
                    if (this.offset.getStartOffset() < this.offsetMark) {
                        this.nullIterator = nullValueBitmap.peekableIterator();
                    }
                    this.offsetMark = this.offset.getStartOffset() + this.offset.getCurrentVectorSize();
                    ColumnarFloats.this.get(this.floatVector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
                } else {
                    int[] offsets = this.offset.getOffsets();
                    if (offsets[offsets.length - 1] < this.offsetMark) {
                        this.nullIterator = nullValueBitmap.peekableIterator();
                    }
                    this.offsetMark = offsets[offsets.length - 1];
                    ColumnarFloats.this.get(this.floatVector, offsets, this.offset.getCurrentVectorSize());
                }
                this.nullVector = VectorSelectorUtils.populateNullVector(this.nullVector, this.offset, this.nullIterator);
                this.id = this.offset.getId();
            }
        }
        return new ColumnarFloatsVectorValueSelector();
    }
}

