/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.column;

import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.IndexIO;
import org.apache.hive.druid.org.apache.druid.segment.column.FloatsColumnWithNulls;
import org.apache.hive.druid.org.apache.druid.segment.column.NumericColumn;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarFloats;
import org.apache.hive.druid.org.apache.druid.segment.data.ReadableOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

public class FloatsColumn
implements NumericColumn {
    final ColumnarFloats column;

    public static FloatsColumn create(ColumnarFloats column, ImmutableBitmap nullValueBitmap) {
        if (nullValueBitmap.isEmpty()) {
            return new FloatsColumn(column);
        }
        return new FloatsColumnWithNulls(column, nullValueBitmap);
    }

    FloatsColumn(ColumnarFloats column) {
        this.column = column;
    }

    @Override
    public int length() {
        return this.column.size();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(ReadableOffset offset) {
        return this.column.makeColumnValueSelector(offset, IndexIO.LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap());
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        return this.column.makeVectorValueSelector(offset, IndexIO.LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap());
    }

    @Override
    public long getLongSingleValueRow(int rowNum) {
        return (long)this.column.get(rowNum);
    }

    @Override
    public void close() {
        this.column.close();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("column", this.column);
    }
}

