/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.org.apache.druid.segment.AbstractIndex;
import org.apache.hive.druid.org.apache.druid.segment.DimensionHandler;
import org.apache.hive.druid.org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.org.apache.druid.segment.Metadata;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnHolder;
import org.apache.hive.druid.org.apache.druid.segment.data.Indexed;
import org.joda.time.Interval;

public class SimpleQueryableIndex
extends AbstractIndex
implements QueryableIndex {
    private final Interval dataInterval;
    private final List<String> columnNames;
    private final Indexed<String> availableDimensions;
    private final BitmapFactory bitmapFactory;
    private final Map<String, Supplier<ColumnHolder>> columns;
    private final SmooshedFileMapper fileMapper;
    @Nullable
    private final Metadata metadata;
    private final Supplier<Map<String, DimensionHandler>> dimensionHandlers;

    public SimpleQueryableIndex(Interval dataInterval, Indexed<String> dimNames, BitmapFactory bitmapFactory, Map<String, Supplier<ColumnHolder>> columns, SmooshedFileMapper fileMapper, @Nullable Metadata metadata, boolean lazy) {
        Preconditions.checkNotNull(columns.get("__time"));
        this.dataInterval = Preconditions.checkNotNull(dataInterval, "dataInterval");
        ImmutableList.Builder columnNamesBuilder = ImmutableList.builder();
        for (String column : columns.keySet()) {
            if ("__time".equals(column)) continue;
            columnNamesBuilder.add(column);
        }
        this.columnNames = columnNamesBuilder.build();
        this.availableDimensions = dimNames;
        this.bitmapFactory = bitmapFactory;
        this.columns = columns;
        this.fileMapper = fileMapper;
        this.metadata = metadata;
        if (lazy) {
            this.dimensionHandlers = Suppliers.memoize(() -> {
                LinkedHashMap<String, DimensionHandler<?, ?, ?>> dimensionHandlerMap = Maps.newLinkedHashMap();
                for (String dim : this.availableDimensions) {
                    ColumnCapabilities capabilities = this.getColumnHolder(dim).getCapabilities();
                    DimensionHandler<?, ?, ?> handler = DimensionHandlerUtils.getHandlerFromCapabilities(dim, capabilities, null);
                    dimensionHandlerMap.put(dim, handler);
                }
                return dimensionHandlerMap;
            });
        } else {
            LinkedHashMap<String, DimensionHandler<?, ?, ?>> dimensionHandlerMap = Maps.newLinkedHashMap();
            for (String dim : this.availableDimensions) {
                ColumnCapabilities capabilities = this.getColumnHolder(dim).getCapabilities();
                DimensionHandler<?, ?, ?> handler = DimensionHandlerUtils.getHandlerFromCapabilities(dim, capabilities, null);
                dimensionHandlerMap.put(dim, handler);
            }
            this.dimensionHandlers = () -> dimensionHandlerMap;
        }
    }

    @VisibleForTesting
    public SimpleQueryableIndex(Interval interval, List<String> columnNames, Indexed<String> availableDimensions, BitmapFactory bitmapFactory, Map<String, Supplier<ColumnHolder>> columns, SmooshedFileMapper fileMapper, @Nullable Metadata metadata, Supplier<Map<String, DimensionHandler>> dimensionHandlers) {
        this.dataInterval = interval;
        this.columnNames = columnNames;
        this.availableDimensions = availableDimensions;
        this.bitmapFactory = bitmapFactory;
        this.columns = columns;
        this.fileMapper = fileMapper;
        this.metadata = metadata;
        this.dimensionHandlers = dimensionHandlers;
    }

    @Override
    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Override
    public int getNumRows() {
        return this.columns.get("__time").get().getLength();
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public StorageAdapter toStorageAdapter() {
        return new QueryableIndexStorageAdapter(this);
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.availableDimensions;
    }

    @Override
    public BitmapFactory getBitmapFactoryForDimensions() {
        return this.bitmapFactory;
    }

    @Override
    @Nullable
    public ColumnHolder getColumnHolder(String columnName) {
        Supplier<ColumnHolder> columnHolderSupplier = this.columns.get(columnName);
        return columnHolderSupplier == null ? null : columnHolderSupplier.get();
    }

    @VisibleForTesting
    public Map<String, Supplier<ColumnHolder>> getColumns() {
        return this.columns;
    }

    @VisibleForTesting
    public SmooshedFileMapper getFileMapper() {
        return this.fileMapper;
    }

    @Override
    public void close() {
        this.fileMapper.close();
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Map<String, DimensionHandler> getDimensionHandlers() {
        return this.dimensionHandlers.get();
    }
}

