/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.MergingRowIterator;
import org.apache.hive.druid.org.apache.druid.segment.RowPointer;
import org.apache.hive.druid.org.apache.druid.segment.TimeAndDimsIterator;
import org.apache.hive.druid.org.apache.druid.segment.TimeAndDimsPointer;
import org.apache.hive.druid.org.apache.druid.segment.TransformableRowIterator;

final class RowCombiningTimeAndDimsIterator
implements TimeAndDimsIterator {
    private static final int MIN_CURRENTLY_COMBINED_ROW_NUM_UNSET_VALUE = -1;
    private final MergingRowIterator mergingIterator;
    private final TimeAndDimsPointer[] markedRowPointersOfOriginalIterators;
    private final AggregateCombiner[] combinedMetricSelectors;
    private final List<String> combinedMetricNames;
    private final TimeAndDimsPointer[] combinedTimeAndDimsPointersByOriginalIteratorIndex;
    private final BitSet indexesOfCurrentlyCombinedOriginalIterators = new BitSet();
    private final int[] minCurrentlyCombinedRowNumByOriginalIteratorIndex;
    private final int[] maxCurrentlyCombinedRowNumByOriginalIteratorIndex;
    @Nullable
    private TimeAndDimsPointer currentTimeAndDimsPointer;
    private int soleCurrentPointSourceOriginalIteratorIndex;
    @Nullable
    private RowPointer nextRowPointer;

    RowCombiningTimeAndDimsIterator(List<TransformableRowIterator> originalIterators, AggregatorFactory[] metricAggs, List<String> metricNames) {
        int numCombinedIterators = originalIterators.size();
        this.mergingIterator = new MergingRowIterator(originalIterators);
        this.markedRowPointersOfOriginalIterators = new TimeAndDimsPointer[numCombinedIterators];
        Arrays.setAll(this.markedRowPointersOfOriginalIterators, originalIteratorIndex -> {
            TransformableRowIterator originalIterator = this.mergingIterator.getOriginalIterator(originalIteratorIndex);
            return originalIterator != null ? originalIterator.getMarkedPointer() : null;
        });
        this.combinedMetricSelectors = new AggregateCombiner[metricAggs.length];
        Arrays.setAll(this.combinedMetricSelectors, metricIndex -> metricAggs[metricIndex].makeNullableAggregateCombiner());
        this.combinedMetricNames = metricNames;
        this.combinedTimeAndDimsPointersByOriginalIteratorIndex = new TimeAndDimsPointer[numCombinedIterators];
        Arrays.setAll(this.combinedTimeAndDimsPointersByOriginalIteratorIndex, originalIteratorIndex -> {
            TimeAndDimsPointer markedRowPointer = this.markedRowPointersOfOriginalIterators[originalIteratorIndex];
            if (markedRowPointer != null) {
                return new TimeAndDimsPointer(markedRowPointer.timestampSelector, markedRowPointer.dimensionSelectors, markedRowPointer.getDimensionHandlers(), this.combinedMetricSelectors, this.combinedMetricNames);
            }
            return null;
        });
        this.minCurrentlyCombinedRowNumByOriginalIteratorIndex = new int[numCombinedIterators];
        Arrays.fill(this.minCurrentlyCombinedRowNumByOriginalIteratorIndex, -1);
        this.maxCurrentlyCombinedRowNumByOriginalIteratorIndex = new int[numCombinedIterators];
        if (this.mergingIterator.moveToNext()) {
            this.nextRowPointer = this.mergingIterator.getPointer();
        }
    }

    private void clearCombinedRowsInfo() {
        int originalIteratorIndex = this.indexesOfCurrentlyCombinedOriginalIterators.nextSetBit(0);
        while (originalIteratorIndex >= 0) {
            this.minCurrentlyCombinedRowNumByOriginalIteratorIndex[originalIteratorIndex] = -1;
            originalIteratorIndex = this.indexesOfCurrentlyCombinedOriginalIterators.nextSetBit(originalIteratorIndex + 1);
        }
        this.indexesOfCurrentlyCombinedOriginalIterators.clear();
    }

    @Override
    public boolean moveToNext() {
        this.clearCombinedRowsInfo();
        if (this.nextRowPointer == null) {
            this.currentTimeAndDimsPointer = null;
            return false;
        }
        this.startNewTimeAndDims(this.nextRowPointer);
        this.nextRowPointer = null;
        this.mergingIterator.mark();
        while (this.mergingIterator.moveToNext()) {
            if (this.mergingIterator.hasTimeAndDimsChangedSinceMark()) {
                this.nextRowPointer = this.mergingIterator.getPointer();
                return true;
            }
            this.combineToCurrentTimeAndDims(this.mergingIterator.getPointer());
        }
        this.nextRowPointer = null;
        return true;
    }

    private void startNewTimeAndDims(RowPointer rowPointer) {
        int rowNum;
        int originalIteratorIndex = rowPointer.getIndexNum();
        this.currentTimeAndDimsPointer = this.markedRowPointersOfOriginalIterators[originalIteratorIndex];
        this.soleCurrentPointSourceOriginalIteratorIndex = originalIteratorIndex;
        this.indexesOfCurrentlyCombinedOriginalIterators.set(originalIteratorIndex);
        this.minCurrentlyCombinedRowNumByOriginalIteratorIndex[originalIteratorIndex] = rowNum = rowPointer.getRowNum();
        this.maxCurrentlyCombinedRowNumByOriginalIteratorIndex[originalIteratorIndex] = rowNum;
    }

    private void combineToCurrentTimeAndDims(RowPointer rowPointer) {
        int soleCurrentPointSourceOriginalIteratorIndex = this.soleCurrentPointSourceOriginalIteratorIndex;
        if (soleCurrentPointSourceOriginalIteratorIndex >= 0) {
            TimeAndDimsPointer currentRowPointer = this.currentTimeAndDimsPointer;
            assert (currentRowPointer != null);
            this.resetCombinedMetrics(currentRowPointer);
            this.currentTimeAndDimsPointer = this.combinedTimeAndDimsPointersByOriginalIteratorIndex[soleCurrentPointSourceOriginalIteratorIndex];
            this.soleCurrentPointSourceOriginalIteratorIndex = -1;
        }
        int originalIteratorIndex = rowPointer.getIndexNum();
        this.indexesOfCurrentlyCombinedOriginalIterators.set(originalIteratorIndex);
        int rowNum = rowPointer.getRowNum();
        if (this.minCurrentlyCombinedRowNumByOriginalIteratorIndex[originalIteratorIndex] < 0) {
            this.minCurrentlyCombinedRowNumByOriginalIteratorIndex[originalIteratorIndex] = rowNum;
        }
        this.maxCurrentlyCombinedRowNumByOriginalIteratorIndex[originalIteratorIndex] = rowNum;
        this.foldMetrics(rowPointer);
    }

    private void resetCombinedMetrics(TimeAndDimsPointer currentRowPointer) {
        for (int metricIndex = 0; metricIndex < this.combinedMetricSelectors.length; ++metricIndex) {
            this.combinedMetricSelectors[metricIndex].reset(currentRowPointer.getMetricSelector(metricIndex));
        }
    }

    private void foldMetrics(RowPointer rowPointer) {
        for (int metricIndex = 0; metricIndex < this.combinedMetricSelectors.length; ++metricIndex) {
            this.combinedMetricSelectors[metricIndex].fold(rowPointer.getMetricSelector(metricIndex));
        }
    }

    @Override
    public TimeAndDimsPointer getPointer() {
        return Objects.requireNonNull(this.currentTimeAndDimsPointer);
    }

    int nextCurrentlyCombinedOriginalIteratorIndex(int fromIndex) {
        return this.indexesOfCurrentlyCombinedOriginalIterators.nextSetBit(fromIndex);
    }

    int getMinCurrentlyCombinedRowNumByOriginalIteratorIndex(int originalIteratorIndex) {
        return this.minCurrentlyCombinedRowNumByOriginalIteratorIndex[originalIteratorIndex];
    }

    int getMaxCurrentlyCombinedRowNumByOriginalIteratorIndex(int originalIteratorIndex) {
        return this.maxCurrentlyCombinedRowNumByOriginalIteratorIndex[originalIteratorIndex];
    }

    @Override
    public void close() {
        this.mergingIterator.close();
    }
}

