/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import it.unimi.dsi.fastutil.objects.ObjectHeaps;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.segment.RowIterator;
import org.apache.hive.druid.org.apache.druid.segment.RowPointer;
import org.apache.hive.druid.org.apache.druid.segment.TransformableRowIterator;

final class MergingRowIterator
implements RowIterator {
    private static final Comparator<RowIterator> ROW_ITERATOR_COMPARATOR = Comparator.comparing(RowIterator::getPointer);
    private final Closer closer = Closer.create();
    private final TransformableRowIterator[] originalIterators;
    private final RowIterator[] pQueue;
    private int pQueueSize;
    private final boolean[] equalToChild;
    private boolean first = true;
    private boolean changedSinceMark = true;
    @Nullable
    private RowIterator lastMarkedHead = null;

    MergingRowIterator(List<TransformableRowIterator> iterators) {
        iterators.forEach(this.closer::register);
        this.originalIterators = new TransformableRowIterator[iterators.size()];
        this.pQueue = (RowIterator[])IntStream.range(0, iterators.size()).filter(indexNum -> ((TransformableRowIterator)iterators.get(indexNum)).moveToNext()).mapToObj(indexNum -> {
            TransformableRowIterator rowIterator = (TransformableRowIterator)iterators.get(indexNum);
            rowIterator.getPointer().setIndexNum(indexNum);
            this.originalIterators[indexNum] = rowIterator;
            return rowIterator;
        }).toArray(RowIterator[]::new);
        this.equalToChild = new boolean[this.pQueue.length];
        this.heapify();
        this.initEqualToChildStates();
    }

    @Nullable
    TransformableRowIterator getOriginalIterator(int indexNum) {
        return this.originalIterators[indexNum];
    }

    @Override
    public RowPointer getPointer() {
        return this.pQueue[0].getPointer();
    }

    @Override
    public boolean moveToNext() {
        if (this.pQueueSize == 0) {
            if (this.first) {
                this.first = false;
                return false;
            }
            throw new IllegalStateException("Don't call moveToNext() after it returned false once");
        }
        if (this.first) {
            this.first = false;
            return true;
        }
        RowIterator head = this.pQueue[0];
        if (!this.changedSinceMark && this.lastMarkedHead != head) {
            head.mark();
            this.lastMarkedHead = head;
        }
        boolean headUsedToBeEqualToChild = this.equalToChild[0];
        if (head.moveToNext()) {
            if (this.sinkHeap(0) == 0) {
                if (!this.changedSinceMark && head.hasTimeAndDimsChangedSinceMark()) {
                    this.changedSinceMark = true;
                }
            } else {
                this.changedSinceMark |= !headUsedToBeEqualToChild;
            }
            return true;
        }
        --this.pQueueSize;
        if (this.pQueueSize > 0) {
            this.pQueue[0] = this.pQueue[this.pQueueSize];
            this.pQueue[this.pQueueSize] = null;
            this.changedSinceMark |= !headUsedToBeEqualToChild;
            int parentOfLast = this.pQueueSize - 1 >> 1;
            this.sinkHeap(parentOfLast);
            this.sinkHeap(0);
            return true;
        }
        return false;
    }

    @Override
    public void mark() {
        this.changedSinceMark = false;
        this.lastMarkedHead = null;
    }

    @Override
    public boolean hasTimeAndDimsChangedSinceMark() {
        return this.changedSinceMark;
    }

    private int sinkHeap(int i) {
        int left;
        RowIterator iteratorToSink = this.pQueue[i];
        while ((left = (i << 1) + 1) < this.pQueueSize) {
            int parentDiff;
            RowIterator rightChildIterator;
            int child = left;
            RowIterator childIterator = this.pQueue[left];
            int right = left + 1;
            int childrenDiff = -1;
            if (right < this.pQueueSize && (childrenDiff = (rightChildIterator = this.pQueue[right]).getPointer().compareTo(childIterator.getPointer())) < 0) {
                child = right;
                childIterator = rightChildIterator;
            }
            if ((parentDiff = iteratorToSink.getPointer().compareTo(childIterator.getPointer())) == 0) {
                this.equalToChild[i] = true;
                this.pQueue[i] = iteratorToSink;
                return i;
            }
            if (parentDiff < 0) {
                this.equalToChild[i] = false;
                this.pQueue[i] = iteratorToSink;
                return i;
            }
            this.equalToChild[i] = childrenDiff == 0 || this.equalToChild[child];
            this.pQueue[i] = childIterator;
            i = child;
        }
        this.equalToChild[i] = false;
        this.pQueue[i] = iteratorToSink;
        return i;
    }

    private void heapify() {
        this.pQueueSize = 0;
        while (this.pQueueSize < this.pQueue.length) {
            ++this.pQueueSize;
            ObjectHeaps.upHeap(this.pQueue, this.pQueueSize, this.pQueueSize - 1, ROW_ITERATOR_COMPARATOR);
        }
    }

    private void initEqualToChildStates() {
        for (int i = 0; i < this.pQueueSize; ++i) {
            int left = (i << 1) + 1;
            int right = left + 1;
            this.equalToChild[i] = left < this.pQueueSize && this.iteratorsEqual(i, left) || right < this.pQueueSize && this.iteratorsEqual(i, right);
        }
    }

    private boolean iteratorsEqual(int i1, int i2) {
        return this.pQueue[i1].getPointer().compareTo(this.pQueue[i2].getPointer()) == 0;
    }

    @Override
    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

