/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.org.apache.druid.segment.DimensionIndexer;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.FloatWrappingDimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.data.CloseableIndexed;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexRowHolder;

public class FloatDimensionIndexer
implements DimensionIndexer<Float, Float, Float> {
    public static final Comparator<Float> FLOAT_COMPARATOR = Comparators.naturalNullsFirst();

    @Override
    public Float processRowValsToUnsortedEncodedKeyComponent(@Nullable Object dimValues, boolean reportParseExceptions) {
        if (dimValues instanceof List) {
            throw new UnsupportedOperationException("Numeric columns do not support multivalue rows.");
        }
        return DimensionHandlerUtils.convertObjectToFloat(dimValues, reportParseExceptions);
    }

    @Override
    public long estimateEncodedKeyComponentSize(Float key) {
        return 4L;
    }

    @Override
    public Float getUnsortedEncodedValueFromSorted(Float sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public CloseableIndexed<Float> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Numeric columns do not support value dictionaries.");
    }

    @Override
    public Float getMinValue() {
        return Float.valueOf(Float.NEGATIVE_INFINITY);
    }

    @Override
    public Float getMaxValue() {
        return Float.valueOf(Float.POSITIVE_INFINITY);
    }

    @Override
    public int getCardinality() {
        return -1;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return new FloatWrappingDimensionSelector(this.makeColumnValueSelector(currEntry, desc), spec.getExtractionFn());
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerFloatColumnSelector
        implements FloatColumnSelector {
            IndexerFloatColumnSelector() {
            }

            @Override
            public boolean isNull() {
                Object[] dims = currEntry.get().getDims();
                return dimIndex >= dims.length || dims[dimIndex] == null;
            }

            @Override
            public float getFloat() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length || dims[dimIndex] == null) {
                    assert (NullHandling.replaceWithDefault());
                    return 0.0f;
                }
                return ((Float)dims[dimIndex]).floatValue();
            }

            @Override
            @Nullable
            public Float getObject() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length || dims[dimIndex] == null) {
                    return NullHandling.defaultFloatValue();
                }
                return (Float)dims[dimIndex];
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerFloatColumnSelector();
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable Float lhs, @Nullable Float rhs) {
        return FLOAT_COMPARATOR.compare(lhs, rhs);
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable Float lhs, @Nullable Float rhs) {
        return Objects.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable Float key) {
        return DimensionHandlerUtils.nullToZero(key).hashCode();
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualList(Float key) {
        return key;
    }

    @Override
    public ColumnValueSelector convertUnsortedValuesToSorted(ColumnValueSelector selectorWithUnsortedValues) {
        return selectorWithUnsortedValues;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(Float key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Numeric columns do not support bitmaps.");
    }
}

