/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.ConstantDimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.hive.druid.org.apache.druid.segment.IdLookup;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.data.ZeroIndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.hive.druid.org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;

public interface DimensionSelector
extends ColumnValueSelector<Object>,
DimensionDictionarySelector,
HotLoopCallee {
    public IndexedInts getRow();

    public ValueMatcher makeValueMatcher(@Nullable String var1);

    public ValueMatcher makeValueMatcher(Predicate<String> var1);

    @Override
    @Deprecated
    default public float getFloat() {
        return 0.0f;
    }

    @Override
    @Deprecated
    default public double getDouble() {
        return 0.0;
    }

    @Override
    @Deprecated
    default public long getLong() {
        return 0L;
    }

    @Override
    @Deprecated
    default public boolean isNull() {
        return false;
    }

    @Nullable
    default public Object defaultGetObject() {
        IndexedInts row = this.getRow();
        int rowSize = row.size();
        if (rowSize == 0) {
            return null;
        }
        if (rowSize == 1) {
            return this.lookupName(row.get(0));
        }
        String[] strings = new String[rowSize];
        for (int i = 0; i < rowSize; ++i) {
            strings[i] = this.lookupName(row.get(i));
        }
        return Arrays.asList(strings);
    }

    public static DimensionSelector constant(@Nullable String value) {
        if (NullHandling.isNullOrEquivalent(value)) {
            return NullDimensionSelectorHolder.NULL_DIMENSION_SELECTOR;
        }
        return new ConstantDimensionSelector(value);
    }

    public static DimensionSelector constant(@Nullable String value, @Nullable ExtractionFn extractionFn) {
        if (extractionFn == null) {
            return DimensionSelector.constant(value);
        }
        return DimensionSelector.constant(extractionFn.apply(value));
    }

    public static boolean isNilSelector(DimensionSelector selector) {
        return selector.nameLookupPossibleInAdvance() && selector.getValueCardinality() == 1 && selector.lookupName(0) == null;
    }

    public static class NullDimensionSelectorHolder {
        private static final NullDimensionSelector NULL_DIMENSION_SELECTOR = new NullDimensionSelector();

        private static class NullDimensionSelector
        implements SingleValueHistoricalDimensionSelector,
        IdLookup {
            private NullDimensionSelector() {
            }

            @Override
            public IndexedInts getRow() {
                return ZeroIndexedInts.instance();
            }

            @Override
            public int getRowValue(int offset) {
                return 0;
            }

            @Override
            public IndexedInts getRow(int offset) {
                return this.getRow();
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                return BooleanValueMatcher.of(value == null);
            }

            @Override
            public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                return BooleanValueMatcher.of(predicate.apply(null));
            }

            @Override
            public int getValueCardinality() {
                return 1;
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                assert (id == 0) : "id = " + id;
                return null;
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return this;
            }

            @Override
            public int lookupId(@Nullable String name) {
                return NullHandling.isNullOrEquivalent(name) ? 0 : -1;
            }

            @Override
            @Nullable
            public Object getObject() {
                return null;
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
    }
}

