/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;

public class ConstantExprEvalSelector
implements ColumnValueSelector<ExprEval> {
    private final long longValue;
    private final float floatValue;
    private final double doubleValue;
    private final ExprEval eval;
    private final boolean isNull;

    public ConstantExprEvalSelector(ExprEval eval) {
        this.eval = Preconditions.checkNotNull(eval, "eval");
        if (NullHandling.sqlCompatible() && eval.isNumericNull()) {
            this.longValue = 0L;
            this.floatValue = 0.0f;
            this.doubleValue = 0.0;
            this.isNull = true;
        } else {
            this.longValue = eval.asLong();
            this.doubleValue = eval.asDouble();
            this.floatValue = (float)this.doubleValue;
            this.isNull = false;
        }
    }

    @Override
    public double getDouble() {
        return this.doubleValue;
    }

    @Override
    public float getFloat() {
        return this.floatValue;
    }

    @Override
    public long getLong() {
        return this.longValue;
    }

    @Override
    public ExprEval getObject() {
        return this.eval;
    }

    @Override
    public Class<ExprEval> classOfObject() {
        return ExprEval.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }
}

