/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.topn;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BinaryOperator;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.AllGranularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorUtil;
import org.apache.hive.druid.org.apache.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNResultValue;
import org.joda.time.DateTime;

public class TopNBinaryFn
implements BinaryOperator<Result<TopNResultValue>> {
    private final DimensionSpec dimSpec;
    private final Granularity gran;
    private final String dimension;
    private final TopNMetricSpec topNMetricSpec;
    private final int threshold;
    private final List<AggregatorFactory> aggregations;
    private final List<PostAggregator> postAggregations;
    private final Comparator comparator;

    public TopNBinaryFn(Granularity granularity, DimensionSpec dimSpec, TopNMetricSpec topNMetricSpec, int threshold, List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        this.dimSpec = dimSpec;
        this.gran = granularity;
        this.topNMetricSpec = topNMetricSpec;
        this.threshold = threshold;
        this.aggregations = aggregatorSpecs;
        this.postAggregations = AggregatorUtil.pruneDependentPostAgg(postAggregatorSpecs, topNMetricSpec.getMetricName(dimSpec));
        this.dimension = dimSpec.getOutputName();
        this.comparator = topNMetricSpec.getComparator(aggregatorSpecs, postAggregatorSpecs);
    }

    @Override
    public Result<TopNResultValue> apply(Result<TopNResultValue> arg1, Result<TopNResultValue> arg2) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        LinkedHashMap<Object, DimensionAndMetricValueExtractor> retVals = new LinkedHashMap<Object, DimensionAndMetricValueExtractor>();
        TopNResultValue arg1Vals = arg1.getValue();
        TopNResultValue arg2Vals = arg2.getValue();
        for (DimensionAndMetricValueExtractor arg1Val : arg1Vals) {
            retVals.put(arg1Val.getDimensionValue(this.dimension), arg1Val);
        }
        for (DimensionAndMetricValueExtractor arg2Val : arg2Vals) {
            Object dimensionValue = arg2Val.getDimensionValue(this.dimension);
            DimensionAndMetricValueExtractor arg1Val = (DimensionAndMetricValueExtractor)retVals.get(dimensionValue);
            if (arg1Val != null) {
                LinkedHashMap<String, Object> retVal = new LinkedHashMap<String, Object>(this.aggregations.size() + 2);
                retVal.put(this.dimension, dimensionValue);
                for (AggregatorFactory factory : this.aggregations) {
                    String metricName = factory.getName();
                    retVal.put(metricName, factory.combine(arg1Val.getMetric(metricName), arg2Val.getMetric(metricName)));
                }
                for (PostAggregator pf : this.postAggregations) {
                    retVal.put(pf.getName(), pf.compute(retVal));
                }
                retVals.put(dimensionValue, new DimensionAndMetricValueExtractor(retVal));
                continue;
            }
            retVals.put(dimensionValue, arg2Val);
        }
        DateTime timestamp = this.gran instanceof AllGranularity ? arg1.getTimestamp() : this.gran.bucketStart(arg1.getTimestamp());
        TopNResultBuilder bob = this.topNMetricSpec.getResultBuilder(timestamp, this.dimSpec, this.threshold, this.comparator, this.aggregations, this.postAggregations);
        for (DimensionAndMetricValueExtractor extractor : retVals.values()) {
            bob.addEntry(extractor);
        }
        return bob.build();
    }
}

