/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.spec;

import java.io.IOException;
import java.util.Collections;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielders;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.hive.druid.org.apache.druid.segment.SegmentMissingException;

public class SpecificSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> base;
    private final SpecificSegmentSpec specificSpec;

    public SpecificSegmentQueryRunner(QueryRunner<T> base, SpecificSegmentSpec specificSpec) {
        this.base = base;
        this.specificSpec = specificSpec;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> input, final ResponseContext responseContext) {
        QueryPlus<T> queryPlus = input.withQuerySegmentSpec(this.specificSpec);
        Query<T> query = queryPlus.getQuery();
        final Thread currThread = Thread.currentThread();
        final String currThreadName = currThread.getName();
        final String newName = StringUtils.format("%s_%s_%s", query.getType(), query.getDataSource(), query.getIntervals());
        final Sequence baseSequence = this.doNamed(currThread, currThreadName, newName, () -> this.base.run(queryPlus, responseContext));
        Sequence segmentMissingCatchingSequence = new Sequence<T>(){

            @Override
            public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                try {
                    return baseSequence.accumulate(initValue, accumulator);
                }
                catch (SegmentMissingException e) {
                    SpecificSegmentQueryRunner.this.appendMissingSegment(responseContext);
                    return initValue;
                }
            }

            @Override
            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                try {
                    return this.makeYielder(baseSequence.toYielder(initValue, accumulator));
                }
                catch (SegmentMissingException e) {
                    SpecificSegmentQueryRunner.this.appendMissingSegment(responseContext);
                    return Yielders.done(initValue, null);
                }
            }

            private <OutType> Yielder<OutType> makeYielder(final Yielder<OutType> yielder) {
                return new Yielder<OutType>(){

                    @Override
                    public OutType get() {
                        return yielder.get();
                    }

                    @Override
                    public Yielder<OutType> next(OutType initValue) {
                        try {
                            return yielder.next(initValue);
                        }
                        catch (SegmentMissingException e) {
                            SpecificSegmentQueryRunner.this.appendMissingSegment(responseContext);
                            return Yielders.done(initValue, null);
                        }
                    }

                    @Override
                    public boolean isDone() {
                        return yielder.isDone();
                    }

                    @Override
                    public void close() throws IOException {
                        yielder.close();
                    }
                };
            }
        };
        return Sequences.wrap(segmentMissingCatchingSequence, new SequenceWrapper(){

            @Override
            public <RetType> RetType wrap(Supplier<RetType> sequenceProcessing) {
                return (RetType)SpecificSegmentQueryRunner.this.doNamed(currThread, currThreadName, newName, sequenceProcessing);
            }
        });
    }

    private void appendMissingSegment(ResponseContext responseContext) {
        responseContext.add(ResponseContext.Key.MISSING_SEGMENTS, Collections.singletonList(this.specificSpec.getDescriptor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <RetType> RetType doNamed(Thread currThread, String currName, String newName, Supplier<RetType> toRun) {
        try {
            currThread.setName(newName);
            RetType RetType = toRun.get();
            return RetType;
        }
        finally {
            currThread.setName(currName);
        }
    }
}

