/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.search;

import com.google.inject.Inject;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.query.search.AutoStrategy;
import org.apache.hive.druid.org.apache.druid.query.search.CursorOnlyStrategy;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuery;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.search.SearchStrategy;
import org.apache.hive.druid.org.apache.druid.query.search.UseIndexesStrategy;

public class SearchStrategySelector {
    private static final EmittingLogger log = new EmittingLogger(SearchStrategySelector.class);
    private final SearchQueryConfig config;

    @Inject
    public SearchStrategySelector(Supplier<SearchQueryConfig> configSupplier) {
        this.config = configSupplier.get();
    }

    public SearchStrategy strategize(SearchQuery query) {
        String strategyString;
        switch (strategyString = this.config.withOverrides(query).getSearchStrategy()) {
            case "auto": {
                log.debug("Auto strategy is selected, query id [%s]", query.getId());
                return AutoStrategy.of(query);
            }
            case "useIndexes": {
                log.debug("Use-index strategy is selected, query id [%s]", query.getId());
                return UseIndexesStrategy.of(query);
            }
            case "cursorOnly": {
                log.debug("Cursor-only strategy is selected, query id [%s]", query.getId());
                return CursorOnlyStrategy.of(query);
            }
        }
        throw new ISE("Unknown strategy[%s], query id [%s]", strategyString, query.getId());
    }
}

