/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.search;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.search.ConciseBitmapDecisionHelper;
import org.apache.hive.druid.org.apache.druid.query.search.RoaringBitmapDecisionHelper;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuery;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQueryDecisionHelper;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQueryExecutor;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.data.Indexed;
import org.apache.hive.druid.org.apache.druid.segment.filter.Filters;
import org.joda.time.Interval;

public abstract class SearchStrategy {
    protected final Filter filter;
    protected final Interval interval;

    protected SearchStrategy(SearchQuery query) {
        this.filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        if (intervals.size() != 1) {
            throw new IAE("Should only have one interval, got[%s]", intervals);
        }
        this.interval = intervals.get(0);
    }

    public abstract List<SearchQueryExecutor> getExecutionPlan(SearchQuery var1, Segment var2);

    public SearchQueryDecisionHelper getDecisionHelper(QueryableIndex index) {
        BitmapFactory bitmapFactory = index.getBitmapFactoryForDimensions();
        if (bitmapFactory.getClass().equals(ConciseBitmapFactory.class)) {
            return ConciseBitmapDecisionHelper.instance();
        }
        if (bitmapFactory.getClass().equals(RoaringBitmapFactory.class)) {
            return RoaringBitmapDecisionHelper.instance();
        }
        throw new IAE("Unknown bitmap type[%s]", bitmapFactory.getClass().getName());
    }

    static List<DimensionSpec> getDimsToSearch(Indexed<String> availableDimensions, List<DimensionSpec> dimensions) {
        if (dimensions == null || dimensions.isEmpty()) {
            return ImmutableList.copyOf(Iterables.transform(availableDimensions, Druids.DIMENSION_IDENTITY));
        }
        return dimensions;
    }
}

